/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.helpers;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.ozone.OzoneAcl;
import org.apache.hadoop.ozone.om.exceptions.OMException;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.ozone.security.acl.IAccessAuthorizer;
import org.apache.hadoop.ozone.security.acl.OzoneAclConfig;
import org.apache.hadoop.ozone.security.acl.RequestContext;
import org.apache.hadoop.security.UserGroupInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OzoneAclUtil {
    static final Logger LOG = LoggerFactory.getLogger(OzoneAclUtil.class);
    private static IAccessAuthorizer.ACLType[] userRights;
    private static IAccessAuthorizer.ACLType[] groupRights;

    private OzoneAclUtil() {
    }

    public static List<OzoneAcl> getDefaultAclList(UserGroupInformation ugi, OzoneConfiguration conf) {
        if (userRights == null || groupRights == null) {
            OzoneAclConfig aclConfig = (OzoneAclConfig)conf.getObject(OzoneAclConfig.class);
            userRights = aclConfig.getUserDefaultRights();
            groupRights = aclConfig.getGroupDefaultRights();
        }
        ArrayList<OzoneAcl> listOfAcls = new ArrayList<OzoneAcl>();
        listOfAcls.add(new OzoneAcl(IAccessAuthorizer.ACLIdentityType.USER, ugi.getShortUserName(), OzoneAcl.AclScope.ACCESS, userRights));
        try {
            String groupName = ugi.getPrimaryGroupName();
            listOfAcls.add(new OzoneAcl(IAccessAuthorizer.ACLIdentityType.GROUP, groupName, OzoneAcl.AclScope.ACCESS, groupRights));
        }
        catch (IOException e) {
            LOG.warn("Failed to get primary group from user {}", (Object)ugi);
        }
        return listOfAcls;
    }

    public static List<OzoneAcl> getAclList(UserGroupInformation ugi, IAccessAuthorizer.ACLType userPrivilege, IAccessAuthorizer.ACLType groupPrivilege) {
        ArrayList<OzoneAcl> listOfAcls = new ArrayList<OzoneAcl>();
        listOfAcls.add(new OzoneAcl(IAccessAuthorizer.ACLIdentityType.USER, ugi.getShortUserName(), OzoneAcl.AclScope.ACCESS, userPrivilege));
        try {
            String groupName = ugi.getPrimaryGroupName();
            listOfAcls.add(new OzoneAcl(IAccessAuthorizer.ACLIdentityType.GROUP, groupName, OzoneAcl.AclScope.ACCESS, groupPrivilege));
        }
        catch (IOException e) {
            LOG.warn("Failed to get primary group from user {}", (Object)ugi);
        }
        return listOfAcls;
    }

    public static List<OzoneAcl> filterAclList(String identityName, IAccessAuthorizer.ACLIdentityType type, List<OzoneAcl> aclList) {
        if (aclList == null || aclList.isEmpty()) {
            return new ArrayList<OzoneAcl>();
        }
        List<OzoneAcl> retList = aclList.stream().filter(acl -> acl.getType() == type && acl.getName().equals(identityName)).collect(Collectors.toList());
        return retList;
    }

    private static boolean checkAccessInAcl(OzoneAcl a, UserGroupInformation ugi, IAccessAuthorizer.ACLType aclToCheck) {
        switch (a.getType()) {
            case USER: {
                if (!a.getName().equals(ugi.getShortUserName())) break;
                return a.checkAccess(aclToCheck);
            }
            case GROUP: {
                for (String grp : ugi.getGroupNames()) {
                    if (!a.getName().equals(grp)) continue;
                    return a.checkAccess(aclToCheck);
                }
                break;
            }
            default: {
                return a.checkAccess(aclToCheck);
            }
        }
        return false;
    }

    public static boolean checkAclRights(List<OzoneAcl> acls, RequestContext context) throws OMException {
        UserGroupInformation clientUgi = context.getClientUgi();
        IAccessAuthorizer.ACLType aclToCheck = context.getAclRights();
        for (OzoneAcl acl : acls) {
            if (!OzoneAclUtil.checkAccessInAcl(acl, clientUgi, aclToCheck)) continue;
            return true;
        }
        return false;
    }

    public static boolean inheritDefaultAcls(List<OzoneAcl> acls, List<OzoneAcl> parentAcls, OzoneAcl.AclScope scope) {
        if (parentAcls != null && !parentAcls.isEmpty()) {
            List<OzoneAcl> inheritedAcls;
            Stream<OzoneAcl> aclStream = parentAcls.stream().filter(a -> a.getAclScope() == OzoneAcl.AclScope.DEFAULT);
            if (scope != OzoneAcl.AclScope.DEFAULT) {
                aclStream = aclStream.map(acl -> acl.withScope(scope));
            }
            if (!(inheritedAcls = aclStream.collect(Collectors.toList())).isEmpty()) {
                inheritedAcls.forEach(acl -> OzoneAclUtil.addAcl(acls, acl));
                return true;
            }
        }
        return false;
    }

    public static List<OzoneAcl> fromProtobuf(List<OzoneManagerProtocolProtos.OzoneAclInfo> protoAcls) {
        ArrayList<OzoneAcl> ozoneAcls = new ArrayList<OzoneAcl>();
        for (OzoneManagerProtocolProtos.OzoneAclInfo aclInfo : protoAcls) {
            ozoneAcls.add(OzoneAcl.fromProtobuf(aclInfo));
        }
        return ozoneAcls;
    }

    public static List<OzoneManagerProtocolProtos.OzoneAclInfo> toProtobuf(List<OzoneAcl> protoAcls) {
        ArrayList<OzoneManagerProtocolProtos.OzoneAclInfo> ozoneAclInfos = new ArrayList<OzoneManagerProtocolProtos.OzoneAclInfo>();
        for (OzoneAcl acl : protoAcls) {
            ozoneAclInfos.add(OzoneAcl.toProtobuf(acl));
        }
        return ozoneAclInfos;
    }

    public static boolean addAcl(List<OzoneAcl> existingAcls, OzoneAcl acl) {
        if (existingAcls == null || acl == null) {
            return false;
        }
        for (int i = 0; i < existingAcls.size(); ++i) {
            boolean changed;
            OzoneAcl a = existingAcls.get(i);
            if (!a.getName().equals(acl.getName()) || !a.getType().equals((Object)acl.getType()) || !a.getAclScope().equals((Object)acl.getAclScope())) continue;
            OzoneAcl updated = a.add(acl);
            boolean bl = changed = !Objects.equals(updated, a);
            if (changed) {
                existingAcls.set(i, updated);
            }
            return changed;
        }
        existingAcls.add(acl);
        return true;
    }

    public static boolean removeAcl(List<OzoneAcl> existingAcls, OzoneAcl acl) {
        if (existingAcls == null || existingAcls.isEmpty() || acl == null) {
            return false;
        }
        for (int i = 0; i < existingAcls.size(); ++i) {
            boolean changed;
            OzoneAcl a = existingAcls.get(i);
            if (!a.getName().equals(acl.getName()) || !a.getType().equals((Object)acl.getType()) || !a.getAclScope().equals((Object)acl.getAclScope())) continue;
            OzoneAcl updated = a.remove(acl);
            boolean bl = changed = !Objects.equals(updated, a);
            if (updated.isEmpty()) {
                existingAcls.remove(i);
            } else if (changed) {
                existingAcls.set(i, updated);
            }
            return changed;
        }
        return false;
    }

    public static boolean setAcl(List<OzoneAcl> existingAcls, List<OzoneAcl> newAcls) {
        if (existingAcls == null) {
            return false;
        }
        existingAcls.clear();
        if (newAcls != null) {
            existingAcls.addAll(newAcls);
        }
        return true;
    }
}

