/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.cli.datanode;

import java.io.IOException;
import java.util.List;
import org.apache.hadoop.hdds.cli.HddsVersionProvider;
import org.apache.hadoop.hdds.scm.DatanodeAdminError;
import org.apache.hadoop.hdds.scm.cli.ScmSubcommand;
import org.apache.hadoop.hdds.scm.cli.datanode.HostNameParameters;
import org.apache.hadoop.hdds.scm.client.ScmClient;
import picocli.CommandLine;

@CommandLine.Command(name="decommission", description={"Decommission a datanode"}, mixinStandardHelpOptions=true, versionProvider=HddsVersionProvider.class)
public class DecommissionSubCommand
extends ScmSubcommand {
    @CommandLine.Mixin
    private HostNameParameters hostNameParams;
    @CommandLine.Option(names={"--force"}, defaultValue="false", description={"Forcefully try to decommission the datanode(s)"})
    private boolean force;

    @Override
    public void execute(ScmClient scmClient) throws IOException {
        List<String> hosts = this.hostNameParams.getHostNames();
        List errors = scmClient.decommissionNodes(hosts, this.force);
        System.out.println("Started decommissioning datanode(s):\n" + String.join((CharSequence)"\n", hosts));
        DecommissionSubCommand.showErrors(errors, "Some nodes could not enter the decommission workflow");
    }

    static void showErrors(List<DatanodeAdminError> errors, String message) throws IOException {
        if (!errors.isEmpty()) {
            for (DatanodeAdminError error : errors) {
                System.err.println("Error: " + error.getHostname() + ": " + error.getError());
            }
            throw new IOException(message);
        }
    }
}

