/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.insight;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import org.apache.hadoop.hdds.cli.HddsVersionProvider;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.ozone.insight.BaseInsightSubCommand;
import org.apache.hadoop.ozone.insight.Component;
import org.apache.hadoop.ozone.insight.InsightPoint;
import org.apache.hadoop.ozone.insight.MetricDisplay;
import org.apache.hadoop.ozone.insight.MetricGroupDisplay;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import picocli.CommandLine;

@CommandLine.Command(name="metrics", aliases={"metric"}, description={"Show available metrics."}, mixinStandardHelpOptions=true, versionProvider=HddsVersionProvider.class)
public class MetricsSubCommand
extends BaseInsightSubCommand
implements Callable<Void> {
    @CommandLine.Option(names={"-f"}, description={"Define filters to scope the output (eg. -f datanode=_1234_datanode_id)"})
    private Map<String, String> filters;
    @CommandLine.Parameters(description={"Name of the insight point (use list to check the available options)"})
    private String insightName;

    @Override
    public Void call() throws Exception {
        OzoneConfiguration conf = this.getInsightCommand().getOzoneConf();
        InsightPoint insight = this.getInsight(conf, this.insightName);
        Set<Component> sources = insight.getMetrics(this.filters).stream().map(MetricGroupDisplay::getComponent).collect(Collectors.toSet());
        Map<Component, List<String>> metrics = this.getMetrics(conf, sources);
        System.out.println("Metrics for `" + this.insightName + "` (" + insight.getDescription() + ")");
        System.out.println();
        for (MetricGroupDisplay group : insight.getMetrics(this.filters)) {
            System.out.println(group.getDescription());
            System.out.println();
            for (MetricDisplay display : group.getMetrics()) {
                System.out.println("  " + display.getDescription() + ": " + this.selectValue(metrics.get(group.getComponent()), display));
            }
            System.out.println();
            System.out.println();
        }
        return null;
    }

    private Map<Component, List<String>> getMetrics(OzoneConfiguration conf, Collection<Component> sources) {
        HashMap<Component, List<String>> result = new HashMap<Component, List<String>>();
        for (Component source : sources) {
            result.put(source, this.getMetrics(conf, source));
        }
        return result;
    }

    private String selectValue(List<String> metrics, MetricDisplay metricDisplay) {
        for (String line : metrics) {
            if (!line.startsWith(metricDisplay.getId())) continue;
            boolean filtered = false;
            for (Map.Entry<String, String> filter : metricDisplay.getFilter().entrySet()) {
                if (line.contains(filter.getKey() + "=\"" + filter.getValue() + "\"")) continue;
                filtered = true;
            }
            if (filtered) continue;
            return line.split(" ")[1];
        }
        return "???";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<String> getMetrics(OzoneConfiguration conf, Component component) {
        CloseableHttpClient client = HttpClientBuilder.create().build();
        HttpGet get = new HttpGet(this.getHost(conf, component) + "/prom");
        try {
            HttpResponse execute = client.execute((HttpUriRequest)get);
            if (execute.getStatusLine().getStatusCode() != 200) {
                throw new RuntimeException("Can't read prometheus metrics endpoint" + execute.getStatusLine().getStatusCode());
            }
            try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(execute.getEntity().getContent(), StandardCharsets.UTF_8));){
                List<String> list = bufferedReader.lines().collect(Collectors.toList());
                return list;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

