/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.formats.letsmt;

import java.io.File;
import java.io.IOException;
import opennlp.tools.cmdline.ArgumentParser;
import opennlp.tools.cmdline.StreamFactoryRegistry;
import opennlp.tools.cmdline.TerminateToolException;
import opennlp.tools.cmdline.params.BasicFormatParams;
import opennlp.tools.commons.Internal;
import opennlp.tools.formats.AbstractSampleStreamFactory;
import opennlp.tools.formats.letsmt.DetokenizeSentenceSampleStream;
import opennlp.tools.formats.letsmt.LetsmtDocument;
import opennlp.tools.formats.letsmt.LetsmtSentenceStream;
import opennlp.tools.sentdetect.SentenceSample;
import opennlp.tools.tokenize.DetokenizationDictionary;
import opennlp.tools.tokenize.Detokenizer;
import opennlp.tools.tokenize.DictionaryDetokenizer;
import opennlp.tools.util.ObjectStream;

@Internal
public class LetsmtSentenceStreamFactory
extends AbstractSampleStreamFactory<SentenceSample, Parameters> {
    public static void registerFactory() {
        StreamFactoryRegistry.registerFactory(SentenceSample.class, "letsmt", new LetsmtSentenceStreamFactory(Parameters.class));
    }

    protected LetsmtSentenceStreamFactory(Class<Parameters> params) {
        super(params);
    }

    public ObjectStream<SentenceSample> create(String[] args) {
        Parameters params = this.validateBasicFormatParameters(args, Parameters.class);
        LetsmtDocument letsmtDoc = null;
        try {
            letsmtDoc = LetsmtDocument.parse(params.getData());
        }
        catch (IOException ex) {
            throw new TerminateToolException(-1, "IO Error while creating an Input Stream: " + ex.getMessage(), (Throwable)ex);
        }
        Object samples = new LetsmtSentenceStream(letsmtDoc);
        if (params.getDetokenizer() != null) {
            try {
                DictionaryDetokenizer detokenizer = new DictionaryDetokenizer(new DetokenizationDictionary(params.getDetokenizer()));
                samples = new DetokenizeSentenceSampleStream((Detokenizer)detokenizer, (ObjectStream<SentenceSample>)samples);
            }
            catch (IOException e) {
                throw new TerminateToolException(-1, "Failed to load detokenizer rules!", (Throwable)e);
            }
        }
        return samples;
    }

    public static interface Parameters
    extends BasicFormatParams {
        @ArgumentParser.ParameterDescription(valueName="dictionary", description="specifies the file with detokenizer dictionary.")
        @ArgumentParser.OptionalParameter
        public File getDetokenizer();
    }
}

