/*
 * Decompiled with CFR 0.152.
 */
package opennlp.uima.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import opennlp.tools.ml.TrainerFactory;
import opennlp.tools.util.Parameters;
import opennlp.tools.util.TrainingParameters;
import opennlp.tools.util.model.BaseModel;
import org.apache.uima.resource.ResourceInitializationException;

public final class OpennlpUtil {
    private OpennlpUtil() {
    }

    public static void serialize(BaseModel model, File modelFile) throws IOException {
        if (model == null) {
            throw new IllegalArgumentException("Parameter 'model' must not be null");
        }
        if (modelFile == null) {
            throw new IllegalArgumentException("Parameter 'modelFile' must not be null");
        }
        try (FileOutputStream fileOut = new FileOutputStream(modelFile);
             BufferedOutputStream modelOut = new BufferedOutputStream(fileOut);){
            model.serialize((OutputStream)modelOut);
        }
    }

    public static byte[] loadBytes(File inFile) throws IOException {
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        try (FileInputStream in = new FileInputStream(inFile);){
            int len;
            byte[] buffer = new byte[1024];
            while ((len = ((InputStream)in).read(buffer)) > 0) {
                bytes.write(buffer, 0, len);
            }
        }
        return bytes.toByteArray();
    }

    public static TrainingParameters loadTrainingParams(String trainingFilePath, boolean isSequenceTrainingAllowed) throws ResourceInitializationException {
        TrainingParameters params;
        if (trainingFilePath != null) {
            try (BufferedInputStream paramsIn = new BufferedInputStream(new FileInputStream(trainingFilePath));){
                params = new TrainingParameters((InputStream)paramsIn);
            }
            catch (IOException e) {
                throw new ResourceInitializationException((Throwable)e);
            }
            if (!TrainerFactory.isValid((Parameters)params)) {
                throw new ResourceInitializationException((Throwable)new RuntimeException("Training parameters file is invalid!"));
            }
            TrainerFactory.TrainerType trainerType = TrainerFactory.getTrainerType((Parameters)params);
            if (!isSequenceTrainingAllowed && TrainerFactory.TrainerType.SEQUENCE_TRAINER.equals((Object)trainerType)) {
                throw new ResourceInitializationException((Throwable)new RuntimeException("Sequence training is not supported!"));
            }
        } else {
            params = TrainingParameters.defaultParams();
        }
        return params;
    }
}

