/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.util;

import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import opennlp.tools.ml.model.Event;
import opennlp.tools.util.ObjectStream;

public abstract class AbstractEventStream<T>
implements ObjectStream<Event> {
    private final ObjectStream<T> samples;
    private Iterator<Event> events = Collections.emptyIterator();

    public AbstractEventStream(ObjectStream<T> samples) {
        this.samples = samples;
    }

    protected abstract Iterator<Event> createEvents(T var1);

    public final Event read() throws IOException {
        Object sample;
        if (this.events.hasNext()) {
            return this.events.next();
        }
        while (!this.events.hasNext() && (sample = this.samples.read()) != null) {
            this.events = this.createEvents(sample);
        }
        if (this.events.hasNext()) {
            return this.read();
        }
        return null;
    }

    public void reset() throws IOException, UnsupportedOperationException {
        this.events = Collections.emptyIterator();
        this.samples.reset();
    }

    public void close() throws IOException {
        this.samples.close();
    }
}

