/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.formats.conllu;

import java.io.IOException;
import opennlp.tools.formats.conllu.ConlluSentence;
import opennlp.tools.formats.conllu.ConlluWordLine;
import opennlp.tools.tokenize.TokenSample;
import opennlp.tools.util.FilterObjectStream;
import opennlp.tools.util.ObjectStream;
import opennlp.tools.util.StringUtil;

public class ConlluTokenSampleStream
extends FilterObjectStream<ConlluSentence, TokenSample> {
    public ConlluTokenSampleStream(ObjectStream<ConlluSentence> samples) {
        super(samples);
    }

    public TokenSample read() throws IOException {
        ConlluSentence sentence = (ConlluSentence)this.samples.read();
        if (sentence != null) {
            if (sentence.getTextComment() != null) {
                StringBuilder text = new StringBuilder(sentence.getTextComment());
                int searchIndex = 0;
                for (ConlluWordLine wordLine : sentence.getWordLines()) {
                    if (wordLine.getId().contains(".")) continue;
                    String token = wordLine.getForm();
                    int tokenIndex = text.indexOf(token, searchIndex);
                    if (tokenIndex == -1) {
                        throw new IOException(String.format("Failed to match token [%s] in sentence [%s] with text [%s]", token, sentence.getSentenceIdComment(), text));
                    }
                    searchIndex = tokenIndex + token.length();
                    if (searchIndex >= text.length() || StringUtil.isWhitespace((char)text.charAt(searchIndex))) continue;
                    text.insert(searchIndex, "<SPLIT>");
                }
                return TokenSample.parse((String)text.toString(), (String)"<SPLIT>");
            }
            throw new IOException("Sentence is missing raw text sample!");
        }
        return null;
    }
}

