/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.registry.client.impl;

import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.client.WebTarget;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.registry.client.FlowClient;
import org.apache.nifi.registry.client.NiFiRegistryException;
import org.apache.nifi.registry.client.RequestConfig;
import org.apache.nifi.registry.client.impl.AbstractJerseyClient;
import org.apache.nifi.registry.diff.VersionedFlowDifference;
import org.apache.nifi.registry.field.Fields;
import org.apache.nifi.registry.flow.VersionedFlow;
import org.apache.nifi.registry.revision.entity.RevisionInfo;

public class JerseyFlowClient
extends AbstractJerseyClient
implements FlowClient {
    private final WebTarget flowsTarget;
    private final WebTarget bucketFlowsTarget;

    public JerseyFlowClient(WebTarget baseTarget) {
        this(baseTarget, null);
    }

    public JerseyFlowClient(WebTarget baseTarget, RequestConfig requestConfig) {
        super(requestConfig);
        this.flowsTarget = baseTarget.path("/flows");
        this.bucketFlowsTarget = baseTarget.path("/buckets/{bucketId}/flows");
    }

    @Override
    public VersionedFlow create(VersionedFlow flow) throws NiFiRegistryException, IOException {
        if (flow == null) {
            throw new IllegalArgumentException("VersionedFlow cannot be null");
        }
        String bucketId = flow.getBucketIdentifier();
        if (StringUtils.isBlank((CharSequence)bucketId)) {
            throw new IllegalArgumentException("Bucket Identifier cannot be blank");
        }
        return this.executeAction("Error creating flow", () -> {
            WebTarget target = this.bucketFlowsTarget.resolveTemplate("bucketId", (Object)bucketId);
            return (VersionedFlow)this.getRequestBuilder(target).post(Entity.entity((Object)flow, (String)"application/json"), VersionedFlow.class);
        });
    }

    @Override
    public VersionedFlow get(String bucketId, String flowId) throws NiFiRegistryException, IOException {
        if (StringUtils.isBlank((CharSequence)bucketId)) {
            throw new IllegalArgumentException("Bucket Identifier cannot be blank");
        }
        if (StringUtils.isBlank((CharSequence)flowId)) {
            throw new IllegalArgumentException("Flow Identifier cannot be blank");
        }
        return this.executeAction("Error retrieving flow", () -> {
            WebTarget target = this.bucketFlowsTarget.path("/{flowId}").resolveTemplate("bucketId", (Object)bucketId).resolveTemplate("flowId", (Object)flowId);
            return (VersionedFlow)this.getRequestBuilder(target).get(VersionedFlow.class);
        });
    }

    @Override
    public VersionedFlow get(String flowId) throws NiFiRegistryException, IOException {
        if (StringUtils.isBlank((CharSequence)flowId)) {
            throw new IllegalArgumentException("Flow Identifier cannot be blank");
        }
        return this.executeAction("Error retrieving flow", () -> {
            WebTarget target = this.flowsTarget.path("/{flowId}").resolveTemplate("flowId", (Object)flowId);
            return (VersionedFlow)this.getRequestBuilder(target).get(VersionedFlow.class);
        });
    }

    @Override
    public VersionedFlow update(String bucketId, VersionedFlow flow) throws NiFiRegistryException, IOException {
        if (StringUtils.isBlank((CharSequence)bucketId)) {
            throw new IllegalArgumentException("Bucket Identifier cannot be blank");
        }
        if (flow == null) {
            throw new IllegalArgumentException("VersionedFlow cannot be null");
        }
        if (StringUtils.isBlank((CharSequence)flow.getIdentifier())) {
            throw new IllegalArgumentException("VersionedFlow identifier must be provided");
        }
        return this.executeAction("Error updating flow", () -> {
            WebTarget target = this.bucketFlowsTarget.path("/{flowId}").resolveTemplate("bucketId", (Object)bucketId).resolveTemplate("flowId", (Object)flow.getIdentifier());
            return (VersionedFlow)this.getRequestBuilder(target).put(Entity.entity((Object)flow, (String)"application/json"), VersionedFlow.class);
        });
    }

    @Override
    public VersionedFlow delete(String bucketId, String flowId) throws NiFiRegistryException, IOException {
        return this.delete(bucketId, flowId, null);
    }

    @Override
    public VersionedFlow delete(String bucketId, String flowId, RevisionInfo revision) throws NiFiRegistryException, IOException {
        if (StringUtils.isBlank((CharSequence)bucketId)) {
            throw new IllegalArgumentException("Bucket Identifier cannot be blank");
        }
        if (StringUtils.isBlank((CharSequence)flowId)) {
            throw new IllegalArgumentException("Flow Identifier cannot be blank");
        }
        return this.executeAction("Error deleting flow", () -> {
            WebTarget target = this.bucketFlowsTarget.path("/{flowId}").resolveTemplate("bucketId", (Object)bucketId).resolveTemplate("flowId", (Object)flowId);
            target = this.addRevisionQueryParams(target, revision);
            return (VersionedFlow)this.getRequestBuilder(target).delete(VersionedFlow.class);
        });
    }

    @Override
    public Fields getFields() throws NiFiRegistryException, IOException {
        return this.executeAction("Error retrieving fields info for flows", () -> {
            WebTarget target = this.flowsTarget.path("/fields");
            return (Fields)this.getRequestBuilder(target).get(Fields.class);
        });
    }

    @Override
    public List<VersionedFlow> getByBucket(String bucketId) throws NiFiRegistryException, IOException {
        if (StringUtils.isBlank((CharSequence)bucketId)) {
            throw new IllegalArgumentException("Bucket Identifier cannot be blank");
        }
        return this.executeAction("Error getting flows for bucket", () -> {
            WebTarget target = this.bucketFlowsTarget;
            VersionedFlow[] versionedFlows = (VersionedFlow[])this.getRequestBuilder(target = target.resolveTemplate("bucketId", (Object)bucketId)).get(VersionedFlow[].class);
            return versionedFlows == null ? Collections.emptyList() : Arrays.asList(versionedFlows);
        });
    }

    @Override
    public VersionedFlowDifference diff(String bucketId, String flowId, Integer versionA, Integer versionB) throws NiFiRegistryException, IOException {
        if (StringUtils.isBlank((CharSequence)bucketId)) {
            throw new IllegalArgumentException("Bucket Identifier cannot be blank");
        }
        if (StringUtils.isBlank((CharSequence)flowId)) {
            throw new IllegalArgumentException("Flow Identifier cannot be blank");
        }
        return this.executeAction("Error retrieving flow", () -> {
            WebTarget target = this.bucketFlowsTarget.path("/{flowId}/diff/{versionA}/{versionB}").resolveTemplate("bucketId", (Object)bucketId).resolveTemplate("flowId", (Object)flowId).resolveTemplate("versionA", (Object)versionA).resolveTemplate("versionB", (Object)versionB);
            return (VersionedFlowDifference)this.getRequestBuilder(target).get(VersionedFlowDifference.class);
        });
    }
}

