/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.api.dto;

import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.xml.bind.annotation.XmlType;
import java.util.List;
import java.util.Set;
import org.apache.nifi.web.api.entity.ParameterContextReferenceEntity;
import org.apache.nifi.web.api.entity.ParameterEntity;
import org.apache.nifi.web.api.entity.ParameterProviderConfigurationEntity;
import org.apache.nifi.web.api.entity.ProcessGroupEntity;

@XmlType(name="parameterContext")
public class ParameterContextDTO {
    private String identifier;
    private String name;
    private String description;
    private Set<ParameterEntity> parameters;
    private Set<ProcessGroupEntity> boundProcessGroups;
    private List<ParameterContextReferenceEntity> inheritedParameterContexts;
    private ParameterProviderConfigurationEntity parameterProviderConfiguration;

    public void setId(String id) {
        this.identifier = id;
    }

    @Schema(description="The ID the Parameter Context.", accessMode=Schema.AccessMode.READ_ONLY)
    public String getId() {
        return this.identifier;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Schema(description="The Name of the Parameter Context.")
    public String getName() {
        return this.name;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Schema(description="The Description of the Parameter Context.")
    public String getDescription() {
        return this.description;
    }

    public void setParameters(Set<ParameterEntity> parameters) {
        this.parameters = parameters;
    }

    @Schema(description="The Parameters for the Parameter Context")
    public Set<ParameterEntity> getParameters() {
        return this.parameters;
    }

    public void setBoundProcessGroups(Set<ProcessGroupEntity> boundProcessGroups) {
        this.boundProcessGroups = boundProcessGroups;
    }

    @Schema(description="A list of references of Parameter Contexts from which this one inherits parameters")
    public List<ParameterContextReferenceEntity> getInheritedParameterContexts() {
        return this.inheritedParameterContexts;
    }

    public void setInheritedParameterContexts(List<ParameterContextReferenceEntity> inheritedParameterContexts) {
        this.inheritedParameterContexts = inheritedParameterContexts;
    }

    @Schema(description="The Process Groups that are bound to this Parameter Context", accessMode=Schema.AccessMode.READ_ONLY)
    public Set<ProcessGroupEntity> getBoundProcessGroups() {
        return this.boundProcessGroups;
    }

    @Schema(description="Optional configuration for a Parameter Provider")
    public ParameterProviderConfigurationEntity getParameterProviderConfiguration() {
        return this.parameterProviderConfiguration;
    }

    public void setParameterProviderConfiguration(ParameterProviderConfigurationEntity parameterProviderConfiguration) {
        this.parameterProviderConfiguration = parameterProviderConfiguration;
    }

    public String toString() {
        return "ParameterContext[id=" + this.identifier + ", name=" + this.name + ", parameters=" + String.valueOf(this.parameters) + "]";
    }
}

