/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.component;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.component.UIMessages;
import javax.faces.context.FacesContext;
import org.apache.myfaces.tobago.component.SupportFieldId;
import org.apache.myfaces.tobago.component.Visual;
import org.apache.myfaces.tobago.layout.OrderBy;

public abstract class AbstractUIMessages
extends UIMessages
implements Visual {
    public List<Item> createMessageList(FacesContext facesContext) {
        Iterator<String> clientIds = this.isGlobalOnly() ? Collections.singleton(null).iterator() : (this.getFor() != null ? Collections.singleton(this.getFor()).iterator() : facesContext.getClientIdsWithMessages());
        List<Item> messages = this.collectMessageList(facesContext, clientIds);
        if (OrderBy.severity == this.getOrderBy()) {
            messages.sort((d1, d2) -> d2.getFacesMessage().getSeverity().getOrdinal() - d1.getFacesMessage().getSeverity().getOrdinal());
        }
        return messages;
    }

    private List<Item> collectMessageList(FacesContext facesContext, Iterator<String> clientIds) {
        ArrayList<Item> messages = new ArrayList<Item>();
        while (clientIds.hasNext()) {
            String clientId = clientIds.next();
            Iterator i = facesContext.getMessages(clientId);
            while (i.hasNext()) {
                FacesMessage facesMessage = (FacesMessage)i.next();
                if (this.getMaxNumber() != null && messages.size() >= this.getMaxNumber()) {
                    return messages;
                }
                if (facesMessage.getSeverity().getOrdinal() < this.getMinSeverity().getOrdinal() || facesMessage.getSeverity().getOrdinal() > this.getMaxSeverity().getOrdinal()) continue;
                UIComponent component = clientId != null ? facesContext.getViewRoot().findComponent(clientId) : null;
                String forId = component instanceof SupportFieldId ? ((SupportFieldId)component).getFieldId(facesContext) : clientId;
                messages.add(new Item(forId, facesMessage));
            }
        }
        return messages;
    }

    public abstract FacesMessage.Severity getMinSeverity();

    public abstract FacesMessage.Severity getMaxSeverity();

    public abstract Integer getMaxNumber();

    public abstract OrderBy getOrderBy();

    public abstract boolean isConfirmation();

    public static class Item {
        private String forId;
        private FacesMessage facesMessage;

        public Item(String clientId, FacesMessage facesMessage) {
            this.forId = clientId;
            this.facesMessage = facesMessage;
        }

        public String getForId() {
            return this.forId;
        }

        public void setForId(String forId) {
            this.forId = forId;
        }

        @Deprecated
        public String getClientId() {
            return this.forId;
        }

        @Deprecated
        public void setClientId(String clientId) {
            this.forId = clientId;
        }

        public FacesMessage getFacesMessage() {
            return this.facesMessage;
        }

        public void setFacesMessage(FacesMessage facesMessage) {
            this.facesMessage = facesMessage;
        }
    }
}

