/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.sftp.client.impl;

import java.io.IOException;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttributeView;
import java.util.Objects;
import org.apache.sshd.common.util.logging.AbstractLoggingBean;
import org.apache.sshd.sftp.client.SftpClient;
import org.apache.sshd.sftp.client.fs.SftpFileSystem;
import org.apache.sshd.sftp.client.fs.SftpFileSystemProvider;
import org.apache.sshd.sftp.client.fs.SftpPath;
import org.apache.sshd.sftp.common.SftpException;

public abstract class AbstractSftpFileAttributeView
extends AbstractLoggingBean
implements FileAttributeView {
    protected final SftpFileSystemProvider provider;
    protected final Path path;
    protected final LinkOption[] options;

    protected AbstractSftpFileAttributeView(SftpFileSystemProvider provider, Path path, LinkOption ... options) {
        this.provider = Objects.requireNonNull(provider, "No file system provider instance");
        this.path = Objects.requireNonNull(path, "No path");
        this.options = options;
    }

    @Override
    public String name() {
        return "view";
    }

    public final SftpFileSystemProvider provider() {
        return this.provider;
    }

    public final Path getPath() {
        return this.path;
    }

    protected SftpClient.Attributes readRemoteAttributes() throws IOException {
        return this.provider.readRemoteAttributes(this.provider.toSftpPath(this.path), this.options);
    }

    protected void writeRemoteAttributes(SftpClient.Attributes attrs) throws IOException {
        SftpPath p = this.provider.toSftpPath(this.path);
        SftpFileSystem fs = (SftpFileSystem)p.getFileSystem();
        try (SftpClient client = fs.getClient();){
            try {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("writeRemoteAttributes({})[{}]: {}", new Object[]{fs, p, attrs});
                }
                client.setStat(p.toString(), attrs);
            }
            catch (SftpException e) {
                if (e.getStatus() == 2) {
                    throw new NoSuchFileException(p.toString());
                }
                throw e;
            }
        }
    }
}

