/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.cling.invoker;

import java.util.Objects;
import java.util.Optional;
import org.apache.maven.api.services.Lookup;
import org.apache.maven.cling.invoker.ContainerCapsule;
import org.apache.maven.cling.invoker.LookupContext;
import org.apache.maven.cling.invoker.Utils;
import org.apache.maven.internal.impl.DefaultLookup;
import org.codehaus.plexus.DefaultPlexusContainer;
import org.codehaus.plexus.PlexusContainer;

public class PlexusContainerCapsule
implements ContainerCapsule {
    private final ClassLoader previousClassLoader;
    private final DefaultPlexusContainer plexusContainer;
    private final Lookup lookup;

    public PlexusContainerCapsule(LookupContext context, ClassLoader previousClassLoader, DefaultPlexusContainer plexusContainer) {
        this.previousClassLoader = Objects.requireNonNull(previousClassLoader, "previousClassLoader");
        this.plexusContainer = Objects.requireNonNull(plexusContainer, "plexusContainer");
        this.lookup = new DefaultLookup((PlexusContainer)plexusContainer);
        this.updateLogging(context);
    }

    @Override
    public void updateLogging(LookupContext context) {
        this.plexusContainer.getLoggerManager().setThresholds(Utils.toPlexusLoggingLevel(context.loggerLevel));
    }

    @Override
    public Lookup getLookup() {
        return this.lookup;
    }

    @Override
    public Optional<ClassLoader> currentThreadClassLoader() {
        return Optional.of(this.plexusContainer.getContainerRealm());
    }

    @Override
    public void close() {
        try {
            this.plexusContainer.dispose();
        }
        finally {
            Thread.currentThread().setContextClassLoader(this.previousClassLoader);
        }
    }
}

