/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.graph;

import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.maven.MavenExecutionException;
import org.apache.maven.execution.MavenExecutionRequest;
import org.apache.maven.execution.ProjectActivation;
import org.apache.maven.project.MavenProject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ProjectSelector {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProjectSelector.class);

    public Set<MavenProject> getActiveProjects(MavenExecutionRequest request, List<MavenProject> projects, List<ProjectActivation.ProjectActivationSettings> projectSelectors) throws MavenExecutionException {
        LinkedHashSet<MavenProject> resolvedOptionalProjects = new LinkedHashSet<MavenProject>();
        HashSet<ProjectActivation.ProjectActivationSettings> unresolvedSelectors = new HashSet<ProjectActivation.ProjectActivationSettings>();
        File baseDirectory = this.getBaseDirectoryFromRequest(request);
        for (ProjectActivation.ProjectActivationSettings activation : projectSelectors) {
            if (!activation.activationSettings().active()) continue;
            String selector = activation.selector();
            Optional<MavenProject> optSelectedProject = this.findOptionalProjectBySelector(projects, baseDirectory, selector);
            if (optSelectedProject.isPresent()) {
                resolvedOptionalProjects.add(optSelectedProject.get());
                if (!activation.activationSettings().recurse()) continue;
                resolvedOptionalProjects.addAll(this.getChildProjects(optSelectedProject.get(), request));
                continue;
            }
            unresolvedSelectors.add(activation);
        }
        if (!unresolvedSelectors.isEmpty()) {
            String requiredSelectors = unresolvedSelectors.stream().filter(pas -> !pas.activationSettings().optional()).map(ProjectActivation.ProjectActivationSettings::selector).collect(Collectors.joining(", "));
            if (!requiredSelectors.isEmpty()) {
                throw new MavenExecutionException("The requested required projects " + requiredSelectors + " do not exist.", request.getPom());
            }
            String optionalSelectors = unresolvedSelectors.stream().map(ProjectActivation.ProjectActivationSettings::selector).collect(Collectors.joining(", "));
            LOGGER.info("The requested optional projects {} do not exist.", (Object)optionalSelectors);
        }
        return resolvedOptionalProjects;
    }

    @Deprecated(since="4.0.0")
    public Set<MavenProject> getRequiredProjectsBySelectors(MavenExecutionRequest request, List<MavenProject> projects, Set<String> projectSelectors) throws MavenExecutionException {
        LinkedHashSet<MavenProject> selectedProjects = new LinkedHashSet<MavenProject>();
        File baseDirectory = this.getBaseDirectoryFromRequest(request);
        for (String selector : projectSelectors) {
            Optional<MavenProject> optSelectedProject = this.findOptionalProjectBySelector(projects, baseDirectory, selector);
            if (!optSelectedProject.isPresent()) {
                String message = "Could not find the selected project in the reactor: " + selector;
                throw new MavenExecutionException(message, request.getPom());
            }
            MavenProject selectedProject = optSelectedProject.get();
            selectedProjects.add(selectedProject);
            selectedProjects.addAll(this.getChildProjects(selectedProject, request));
        }
        return selectedProjects;
    }

    @Deprecated(since="4.0.0")
    public Set<MavenProject> getOptionalProjectsBySelectors(MavenExecutionRequest request, List<MavenProject> projects, Set<String> projectSelectors) {
        LinkedHashSet<MavenProject> resolvedOptionalProjects = new LinkedHashSet<MavenProject>();
        HashSet<String> unresolvedOptionalSelectors = new HashSet<String>();
        File baseDirectory = this.getBaseDirectoryFromRequest(request);
        for (String selector : projectSelectors) {
            Optional<MavenProject> optSelectedProject = this.findOptionalProjectBySelector(projects, baseDirectory, selector);
            if (optSelectedProject.isPresent()) {
                resolvedOptionalProjects.add(optSelectedProject.get());
                resolvedOptionalProjects.addAll(this.getChildProjects(optSelectedProject.get(), request));
                continue;
            }
            unresolvedOptionalSelectors.add(selector);
        }
        if (!unresolvedOptionalSelectors.isEmpty()) {
            LOGGER.info("The requested optional projects {} do not exist.", unresolvedOptionalSelectors);
        }
        return resolvedOptionalProjects;
    }

    private List<MavenProject> getChildProjects(MavenProject parent, MavenExecutionRequest request) {
        List<MavenProject> children = parent.getCollectedProjects();
        if (children != null && request.isRecursive()) {
            return children;
        }
        return new ArrayList<MavenProject>();
    }

    private Optional<MavenProject> findOptionalProjectBySelector(List<MavenProject> projects, File reactorDirectory, String selector) {
        return projects.stream().filter(project -> this.isMatchingProject((MavenProject)project, selector, reactorDirectory)).findFirst();
    }

    File getBaseDirectoryFromRequest(MavenExecutionRequest request) {
        return request.getBaseDirectory() != null ? new File(request.getBaseDirectory()) : null;
    }

    boolean isMatchingProject(MavenProject project, String selector, File reactorDirectory) {
        if (selector.contains(":")) {
            String id = ":" + project.getArtifactId();
            if (id.equals(selector)) {
                return true;
            }
            id = project.getGroupId() + id;
            return id.equals(selector);
        }
        if (reactorDirectory != null) {
            File selectedProject = new File(new File(reactorDirectory, selector).toURI().normalize());
            if (selectedProject.isFile()) {
                return selectedProject.equals(project.getFile());
            }
            if (selectedProject.isDirectory()) {
                return selectedProject.equals(project.getBasedir());
            }
        }
        return false;
    }
}

