/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.servlet;

import com.github.tomakehurst.wiremock.common.Slf4jNotifier;
import com.github.tomakehurst.wiremock.core.WireMockApp;
import com.github.tomakehurst.wiremock.http.AdminRequestHandler;
import com.github.tomakehurst.wiremock.http.StubRequestHandler;
import com.github.tomakehurst.wiremock.servlet.NotImplementedContainer;
import com.github.tomakehurst.wiremock.servlet.WarConfiguration;
import com.google.common.base.MoreObjects;
import com.google.common.base.Optional;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;

public class WireMockWebContextListener
implements ServletContextListener {
    private static final String APP_CONTEXT_KEY = "WireMockApp";

    public void contextInitialized(ServletContextEvent sce) {
        ServletContext context = sce.getServletContext();
        boolean verboseLoggingEnabled = Boolean.parseBoolean((String)MoreObjects.firstNonNull((Object)context.getInitParameter("verboseLoggingEnabled"), (Object)"true"));
        WireMockApp wireMockApp = new WireMockApp(new WarConfiguration(context), new NotImplementedContainer());
        context.setAttribute(APP_CONTEXT_KEY, (Object)wireMockApp);
        context.setAttribute(StubRequestHandler.class.getName(), (Object)wireMockApp.buildStubRequestHandler());
        context.setAttribute(AdminRequestHandler.class.getName(), (Object)wireMockApp.buildAdminRequestHandler());
        context.setAttribute("Notifier", (Object)new Slf4jNotifier(verboseLoggingEnabled));
    }

    private Optional<Integer> readMaxRequestJournalEntries(ServletContext context) {
        String str = context.getInitParameter("maxRequestJournalEntries");
        if (str == null) {
            return Optional.absent();
        }
        return Optional.of((Object)Integer.parseInt(str));
    }

    public void contextDestroyed(ServletContextEvent sce) {
    }
}

