/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.crawler.connectors.webcrawler;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.http.cookie.Cookie;
import org.apache.http.impl.cookie.BasicClientCookie2;
import org.apache.manifoldcf.core.cachemanager.BaseDescription;
import org.apache.manifoldcf.core.cachemanager.ExecutorBase;
import org.apache.manifoldcf.core.database.BaseTable;
import org.apache.manifoldcf.core.interfaces.CacheManagerFactory;
import org.apache.manifoldcf.core.interfaces.ColumnDescription;
import org.apache.manifoldcf.core.interfaces.ICacheClass;
import org.apache.manifoldcf.core.interfaces.ICacheDescription;
import org.apache.manifoldcf.core.interfaces.ICacheExecutor;
import org.apache.manifoldcf.core.interfaces.ICacheHandle;
import org.apache.manifoldcf.core.interfaces.ICacheManager;
import org.apache.manifoldcf.core.interfaces.IDBInterface;
import org.apache.manifoldcf.core.interfaces.IResultRow;
import org.apache.manifoldcf.core.interfaces.IResultSet;
import org.apache.manifoldcf.core.interfaces.IThreadContext;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;
import org.apache.manifoldcf.core.interfaces.StringSet;
import org.apache.manifoldcf.core.interfaces.StringSetBuffer;
import org.apache.manifoldcf.crawler.connectors.webcrawler.LoginCookies;

public class CookieManager
extends BaseTable {
    public static final String _rcsid = "@(#)$Id: CookieManager.java 988245 2010-08-23 18:39:35Z kwright $";
    protected static CookiesCacheClass cookiesCacheClass = new CookiesCacheClass();
    protected static final String keyField = "sequencekey";
    protected static final String ordinalField = "ordinal";
    protected static final String domainSpecifiedField = "domainspecified";
    protected static final String domainField = "domain";
    protected static final String nameField = "name";
    protected static final String valueField = "value";
    protected static final String pathSpecifiedField = "pathspecified";
    protected static final String pathField = "path";
    protected static final String versionSpecifiedField = "versionspecified";
    protected static final String versionField = "version";
    protected static final String commentField = "comment";
    protected static final String secureField = "secure";
    protected static final String expirationDateField = "expirationdate";
    protected static final String discardField = "discard";
    protected static final String commentURLField = "commenturl";
    protected static final String portBlankField = "portblank";
    protected static final String portSpecifiedField = "portspecified";
    protected static final String portField = "ports";
    ICacheManager cacheManager;

    public CookieManager(IThreadContext tc, IDBInterface database) throws ManifoldCFException {
        super(database, "cookiedata");
        this.cacheManager = CacheManagerFactory.make((IThreadContext)tc);
    }

    public void install() throws ManifoldCFException {
        this.beginTransaction();
        try {
            Map existing = this.getTableSchema(null, null);
            if (existing == null) {
                HashMap<String, ColumnDescription> map = new HashMap<String, ColumnDescription>();
                map.put(keyField, new ColumnDescription("VARCHAR(255)", false, false, null, null, false));
                map.put(ordinalField, new ColumnDescription("BIGINT", false, false, null, null, false));
                map.put(domainSpecifiedField, new ColumnDescription("CHAR(1)", false, false, null, null, false));
                map.put(domainField, new ColumnDescription("LONGTEXT", false, true, null, null, false));
                map.put(nameField, new ColumnDescription("LONGTEXT", false, true, null, null, false));
                map.put(valueField, new ColumnDescription("LONGTEXT", false, true, null, null, false));
                map.put(pathSpecifiedField, new ColumnDescription("CHAR(1)", false, false, null, null, false));
                map.put(pathField, new ColumnDescription("LONGTEXT", false, true, null, null, false));
                map.put(versionSpecifiedField, new ColumnDescription("CHAR(1)", false, false, null, null, false));
                map.put(versionField, new ColumnDescription("BIGINT", false, true, null, null, false));
                map.put(commentField, new ColumnDescription("LONGTEXT", false, true, null, null, false));
                map.put(secureField, new ColumnDescription("CHAR(1)", false, false, null, null, false));
                map.put(expirationDateField, new ColumnDescription("BIGINT", false, true, null, null, false));
                map.put(discardField, new ColumnDescription("CHAR(1)", false, false, null, null, false));
                map.put(commentURLField, new ColumnDescription("LONGTEXT", false, true, null, null, false));
                map.put(portBlankField, new ColumnDescription("CHAR(1)", false, false, null, null, false));
                map.put(portSpecifiedField, new ColumnDescription("CHAR(1)", false, false, null, null, false));
                map.put(portField, new ColumnDescription("LONGTEXT", false, true, null, null, false));
                this.performCreate(map, null);
                ArrayList<String> list = new ArrayList<String>();
                list.add(keyField);
                this.addTableIndex(false, list);
            }
        }
        catch (ManifoldCFException e) {
            this.signalRollback();
            throw e;
        }
        catch (Error e) {
            this.signalRollback();
            throw e;
        }
        finally {
            this.endTransaction();
        }
    }

    public void deinstall() throws ManifoldCFException {
        this.performDrop(null);
    }

    public LoginCookies readCookies(String sessionKey) throws ManifoldCFException {
        CookiesDescription[] objectDescriptions = new CookiesDescription[1];
        StringSetBuffer ssb = new StringSetBuffer();
        ssb.add(CookieManager.getCookiesCacheKey(sessionKey));
        objectDescriptions[0] = new CookiesDescription(sessionKey, new StringSet(ssb));
        CookiesExecutor exec = new CookiesExecutor(this, objectDescriptions[0]);
        this.cacheManager.findObjectsAndExecute((ICacheDescription[])objectDescriptions, null, (ICacheExecutor)exec, this.getTransactionID());
        return exec.getResults();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateCookies(String sessionKey, LoginCookies cookies) throws ManifoldCFException {
        StringSetBuffer ssb = new StringSetBuffer();
        ssb.add(CookieManager.getCookiesCacheKey(sessionKey));
        StringSet cacheKeys = new StringSet(ssb);
        ICacheHandle ch = this.cacheManager.enterCache(null, cacheKeys, this.getTransactionID());
        try {
            this.beginTransaction();
            try {
                ArrayList<String> list = new ArrayList<String>();
                list.add(sessionKey);
                this.performDelete("WHERE sequencekey=?", list, null);
                for (int i = 0; i < cookies.getCookieCount(); ++i) {
                    int[] ports;
                    String path;
                    String value;
                    Cookie c = cookies.getCookie(i);
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    map.put(keyField, sessionKey);
                    map.put(ordinalField, new Long(i));
                    String domain = c.getDomain();
                    if (domain != null && domain.length() > 0) {
                        map.put(domainField, domain);
                    }
                    map.put(domainSpecifiedField, CookieManager.booleanToString(domain != null && domain.length() > 0));
                    String name = c.getName();
                    if (name != null && name.length() > 0) {
                        map.put(nameField, name);
                    }
                    if ((value = c.getValue()) != null && value.length() > 0) {
                        map.put(valueField, value);
                    }
                    if ((path = c.getPath()) != null && path.length() > 0) {
                        map.put(pathField, path);
                    }
                    map.put(pathSpecifiedField, CookieManager.booleanToString(path != null && path.length() > 0));
                    map.put(versionField, new Long(c.getVersion()));
                    map.put(versionSpecifiedField, CookieManager.booleanToString(true));
                    String comment = c.getComment();
                    if (comment != null && comment.length() > 0) {
                        map.put(commentField, comment);
                    }
                    map.put(secureField, CookieManager.booleanToString(c.isSecure()));
                    Date expirationDate = c.getExpiryDate();
                    if (expirationDate != null) {
                        map.put(expirationDateField, new Long(expirationDate.getTime()));
                    }
                    map.put(discardField, CookieManager.booleanToString(false));
                    String commentURL = c.getCommentURL();
                    if (commentURL != null && commentURL.length() > 0) {
                        map.put(commentURLField, commentURL);
                    }
                    if ((ports = c.getPorts()) != null && ports.length > 0) {
                        map.put(portField, CookieManager.portsToString(ports));
                    }
                    map.put(portBlankField, CookieManager.booleanToString(ports == null || ports.length == 0));
                    map.put(portSpecifiedField, CookieManager.booleanToString(ports != null && ports.length > 0));
                    this.performInsert(map, null);
                }
                this.cacheManager.invalidateKeys(ch);
            }
            catch (ManifoldCFException e) {
                this.signalRollback();
                throw e;
            }
            catch (Error e) {
                this.signalRollback();
                throw e;
            }
            finally {
                this.endTransaction();
            }
        }
        finally {
            this.cacheManager.leaveCache(ch);
        }
    }

    protected static String getCookiesCacheKey(String sessionKey) {
        return "COOKIES_" + sessionKey;
    }

    protected LoginCookies readCookiesUncached(String sessionKey) throws ManifoldCFException {
        ArrayList<String> list = new ArrayList<String>();
        list.add(sessionKey);
        IResultSet result = this.performQuery("SELECT * FROM " + this.getTableName() + " WHERE sequencekey=? ORDER BY ordinal ASC", list, null, null);
        DynamicCookieSet dcs = new DynamicCookieSet();
        int i = 0;
        while (i < result.getRowCount()) {
            String ports;
            String comment;
            Long version;
            String path;
            IResultRow row = result.getRow(i++);
            String name = (String)row.getValue(nameField);
            String value = (String)row.getValue(valueField);
            BasicClientCookie2 c = new BasicClientCookie2(name, value);
            String domain = (String)row.getValue(domainField);
            if (domain != null && domain.length() > 0) {
                c.setDomain(domain);
            }
            if ((path = (String)row.getValue(pathField)) != null && path.length() > 0) {
                c.setPath(path);
            }
            if ((version = (Long)row.getValue(versionField)) != null) {
                c.setVersion((int)version.longValue());
            }
            if ((comment = (String)row.getValue(commentField)) != null) {
                c.setComment(comment);
            }
            c.setSecure(CookieManager.stringToBoolean((String)row.getValue(secureField)));
            Long expirationDate = (Long)row.getValue(expirationDateField);
            if (expirationDate != null) {
                c.setExpiryDate(new Date(expirationDate));
            }
            c.setDiscard(CookieManager.stringToBoolean((String)row.getValue(discardField)));
            String commentURL = (String)row.getValue(commentURLField);
            if (commentURL != null && commentURL.length() > 0) {
                c.setCommentURL(commentURL);
            }
            if ((ports = (String)row.getValue(portField)) != null && ports.length() > 0) {
                c.setPorts(CookieManager.stringToPorts(ports));
            }
            dcs.addCookie((Cookie)c);
        }
        return dcs;
    }

    protected static boolean stringToBoolean(String value) throws ManifoldCFException {
        if (value.equals("T")) {
            return true;
        }
        if (value.equals("F")) {
            return false;
        }
        throw new ManifoldCFException("Expected T or F but saw " + value);
    }

    protected static String booleanToString(boolean value) {
        if (value) {
            return "T";
        }
        return "F";
    }

    protected static int[] stringToPorts(String value) throws ManifoldCFException {
        String[] ports = value.split(",");
        int[] rval = new int[ports.length];
        for (int i = 0; i < rval.length; ++i) {
            try {
                rval[i] = Integer.parseInt(ports[i]);
                continue;
            }
            catch (NumberFormatException e) {
                throw new ManifoldCFException(e.getMessage(), (Throwable)e);
            }
        }
        return rval;
    }

    protected static String portsToString(int[] ports) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < ports.length; ++i) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append(Integer.toString(ports[i]));
        }
        return sb.toString();
    }

    protected static class CookiesExecutor
    extends ExecutorBase {
        protected CookieManager thisManager;
        protected LoginCookies returnValue;
        protected CookiesDescription thisDescription;

        public CookiesExecutor(CookieManager manager, CookiesDescription objectDescription) {
            this.thisManager = manager;
            this.thisDescription = objectDescription;
            this.returnValue = null;
        }

        public LoginCookies getResults() {
            return this.returnValue;
        }

        public Object[] create(ICacheDescription[] objectDescriptions) throws ManifoldCFException {
            Object[] rval = new LoginCookies[objectDescriptions.length];
            for (int i = 0; i < rval.length; ++i) {
                CookiesDescription desc = (CookiesDescription)objectDescriptions[i];
                rval[i] = this.thisManager.readCookiesUncached(desc.getSessionKey());
            }
            return rval;
        }

        public void exists(ICacheDescription objectDescription, Object cachedObject) throws ManifoldCFException {
            CookiesDescription objectDesc = (CookiesDescription)objectDescription;
            LoginCookies cookiesData = (LoginCookies)cachedObject;
            if (objectDesc.equals((Object)this.thisDescription)) {
                this.returnValue = cookiesData;
            }
        }

        public void execute() throws ManifoldCFException {
        }
    }

    protected static class CookiesCacheClass
    implements ICacheClass {
        protected CookiesCacheClass() {
        }

        public String getClassName() {
            return "COOKIESCLASS";
        }

        public int getMaxLRUCount() {
            return 2000;
        }
    }

    protected static class CookiesDescription
    extends BaseDescription {
        protected String sessionKey;
        protected String criticalSectionName;
        protected StringSet cacheKeys;

        public CookiesDescription(String sessionKey, StringSet invKeys) {
            super("cookiescache");
            this.sessionKey = sessionKey;
            this.criticalSectionName = ((Object)((Object)this)).getClass().getName() + "-" + sessionKey;
            this.cacheKeys = invKeys;
        }

        public String getSessionKey() {
            return this.sessionKey;
        }

        public int hashCode() {
            return this.sessionKey.hashCode();
        }

        public boolean equals(Object o) {
            if (!(o instanceof CookiesDescription)) {
                return false;
            }
            CookiesDescription d = (CookiesDescription)((Object)o);
            return d.sessionKey.equals(this.sessionKey);
        }

        public String getCriticalSectionName() {
            return this.criticalSectionName;
        }

        public StringSet getObjectKeys() {
            return this.cacheKeys;
        }

        public ICacheClass getObjectClass() {
            return cookiesCacheClass;
        }
    }

    protected static class DynamicCookieSet
    implements LoginCookies {
        protected List<Cookie> cookies = new ArrayList<Cookie>();

        public void addCookie(Cookie c) {
            this.cookies.add(c);
        }

        @Override
        public int getCookieCount() {
            return this.cookies.size();
        }

        @Override
        public Cookie getCookie(int index) {
            return this.cookies.get(index);
        }
    }
}

