/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.agents.outputconnectorpool;

import org.apache.manifoldcf.agents.interfaces.IOutputConnection;
import org.apache.manifoldcf.agents.interfaces.IOutputConnectionManager;
import org.apache.manifoldcf.agents.interfaces.IOutputConnector;
import org.apache.manifoldcf.agents.interfaces.IOutputConnectorManager;
import org.apache.manifoldcf.agents.interfaces.IOutputConnectorPool;
import org.apache.manifoldcf.agents.interfaces.OutputConnectionManagerFactory;
import org.apache.manifoldcf.agents.interfaces.OutputConnectorManagerFactory;
import org.apache.manifoldcf.core.connectorpool.ConnectorPool;
import org.apache.manifoldcf.core.interfaces.ConfigParams;
import org.apache.manifoldcf.core.interfaces.IThreadContext;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;

public class OutputConnectorPool
implements IOutputConnectorPool {
    public static final String _rcsid = "@(#)$Id$";
    protected static final LocalPool localPool = new LocalPool();
    protected final IThreadContext threadContext;

    public OutputConnectorPool(IThreadContext threadContext) throws ManifoldCFException {
        this.threadContext = threadContext;
    }

    @Override
    public IOutputConnector[] grabMultiple(String[] orderingKeys, IOutputConnection[] outputConnections) throws ManifoldCFException {
        String[] connectionNames = new String[outputConnections.length];
        String[] classNames = new String[outputConnections.length];
        ConfigParams[] configInfos = new ConfigParams[outputConnections.length];
        int[] maxPoolSizes = new int[outputConnections.length];
        for (int i = 0; i < outputConnections.length; ++i) {
            connectionNames[i] = outputConnections[i].getName();
            classNames[i] = outputConnections[i].getClassName();
            configInfos[i] = outputConnections[i].getConfigParams();
            maxPoolSizes[i] = outputConnections[i].getMaxConnections();
        }
        return localPool.grabMultiple(this.threadContext, orderingKeys, connectionNames, classNames, configInfos, maxPoolSizes);
    }

    @Override
    public IOutputConnector grab(IOutputConnection outputConnection) throws ManifoldCFException {
        return (IOutputConnector)localPool.grab(this.threadContext, outputConnection.getName(), outputConnection.getClassName(), outputConnection.getConfigParams(), outputConnection.getMaxConnections());
    }

    @Override
    public void releaseMultiple(IOutputConnection[] connections, IOutputConnector[] connectors) throws ManifoldCFException {
        String[] connectionNames = new String[connections.length];
        for (int i = 0; i < connections.length; ++i) {
            connectionNames[i] = connections[i].getName();
        }
        localPool.releaseMultiple(this.threadContext, connectionNames, connectors);
    }

    @Override
    public void release(IOutputConnection connection, IOutputConnector connector) throws ManifoldCFException {
        localPool.release(this.threadContext, connection.getName(), connector);
    }

    @Override
    public void pollAllConnectors() throws ManifoldCFException {
        localPool.pollAllConnectors(this.threadContext);
    }

    @Override
    public void flushUnusedConnectors() throws ManifoldCFException {
        localPool.flushUnusedConnectors(this.threadContext);
    }

    @Override
    public void closeAllConnectors() throws ManifoldCFException {
        localPool.closeAllConnectors(this.threadContext);
    }

    protected static class LocalPool
    extends ConnectorPool<IOutputConnector> {
        public LocalPool() {
            super("_OUTPUTCONNECTORPOOL_");
        }

        protected boolean isInstalled(IThreadContext tc, String className) throws ManifoldCFException {
            IOutputConnectorManager connectorManager = OutputConnectorManagerFactory.make(tc);
            return connectorManager.isInstalled(className);
        }

        protected boolean isConnectionNameValid(IThreadContext tc, String connectionName) throws ManifoldCFException {
            IOutputConnectionManager connectionManager = OutputConnectionManagerFactory.make(tc);
            return connectionManager.load(connectionName) != null;
        }

        public IOutputConnector[] grabMultiple(IThreadContext tc, String[] orderingKeys, String[] connectionNames, String[] classNames, ConfigParams[] configInfos, int[] maxPoolSizes) throws ManifoldCFException {
            return (IOutputConnector[])this.grabMultiple(tc, IOutputConnector.class, orderingKeys, connectionNames, classNames, configInfos, maxPoolSizes);
        }
    }
}

