/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.vectorhighlight;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.lucene.search.vectorhighlight.FieldQuery;
import org.apache.lucene.search.vectorhighlight.FieldTermStack;
import org.apache.lucene.util.MergedIterator;

public class FieldPhraseList {
    LinkedList<WeightedPhraseInfo> phraseList = new LinkedList();

    public FieldPhraseList(FieldTermStack fieldTermStack, FieldQuery fieldQuery) {
        this(fieldTermStack, fieldQuery, Integer.MAX_VALUE);
    }

    public List<WeightedPhraseInfo> getPhraseList() {
        return this.phraseList;
    }

    public FieldPhraseList(FieldTermStack fieldTermStack, FieldQuery fieldQuery, int phraseLimit) {
        String field = fieldTermStack.getFieldName();
        LinkedList<FieldTermStack.TermInfo> phraseCandidate = new LinkedList<FieldTermStack.TermInfo>();
        FieldQuery.QueryPhraseMap currMap = null;
        FieldQuery.QueryPhraseMap nextMap = null;
        block0: while (!fieldTermStack.isEmpty() && this.phraseList.size() < phraseLimit) {
            phraseCandidate.clear();
            FieldTermStack.TermInfo ti = null;
            FieldTermStack.TermInfo first = null;
            first = ti = fieldTermStack.pop();
            currMap = fieldQuery.getFieldTermMap(field, ti.getText());
            while (currMap == null && ti.getNext() != first) {
                ti = ti.getNext();
                currMap = fieldQuery.getFieldTermMap(field, ti.getText());
            }
            if (currMap == null) continue;
            phraseCandidate.add(ti);
            while (true) {
                first = ti = fieldTermStack.pop();
                nextMap = null;
                if (ti != null) {
                    nextMap = currMap.getTermMap(ti.getText());
                    while (nextMap == null && ti.getNext() != first) {
                        ti = ti.getNext();
                        nextMap = currMap.getTermMap(ti.getText());
                    }
                }
                if (ti == null || nextMap == null) {
                    if (ti != null) {
                        fieldTermStack.push(ti);
                    }
                    if (currMap.isValidTermOrPhrase(phraseCandidate)) {
                        this.addIfNoOverlap(new WeightedPhraseInfo(phraseCandidate, currMap.getBoost(), currMap.getTermOrPhraseNumber()));
                        continue block0;
                    }
                    while (phraseCandidate.size() > 1) {
                        fieldTermStack.push(phraseCandidate.removeLast());
                        currMap = fieldQuery.searchPhrase(field, phraseCandidate);
                        if (currMap == null) continue;
                        this.addIfNoOverlap(new WeightedPhraseInfo(phraseCandidate, currMap.getBoost(), currMap.getTermOrPhraseNumber()));
                        continue block0;
                    }
                    continue block0;
                }
                phraseCandidate.add(ti);
                currMap = nextMap;
            }
        }
    }

    public FieldPhraseList(FieldPhraseList[] toMerge) {
        Iterator[] allInfos = new Iterator[toMerge.length];
        int index = 0;
        for (FieldPhraseList fplToMerge : toMerge) {
            allInfos[index++] = fplToMerge.phraseList.iterator();
        }
        MergedIterator itr = new MergedIterator(false, allInfos);
        this.phraseList = new LinkedList();
        if (!itr.hasNext()) {
            return;
        }
        ArrayList<WeightedPhraseInfo> work = new ArrayList<WeightedPhraseInfo>();
        WeightedPhraseInfo first = (WeightedPhraseInfo)itr.next();
        work.add(first);
        int workEndOffset = first.getEndOffset();
        while (itr.hasNext()) {
            WeightedPhraseInfo current = (WeightedPhraseInfo)itr.next();
            if (current.getStartOffset() <= workEndOffset) {
                workEndOffset = Math.max(workEndOffset, current.getEndOffset());
                work.add(current);
                continue;
            }
            if (work.size() == 1) {
                this.phraseList.add((WeightedPhraseInfo)work.get(0));
                work.set(0, current);
            } else {
                this.phraseList.add(new WeightedPhraseInfo(work));
                work.clear();
                work.add(current);
            }
            workEndOffset = current.getEndOffset();
        }
        if (work.size() == 1) {
            this.phraseList.add((WeightedPhraseInfo)work.get(0));
        } else {
            this.phraseList.add(new WeightedPhraseInfo(work));
            work.clear();
        }
    }

    public void addIfNoOverlap(WeightedPhraseInfo wpi) {
        for (WeightedPhraseInfo existWpi : this.getPhraseList()) {
            if (!existWpi.isOffsetOverlap(wpi)) continue;
            existWpi.getTermsInfos().addAll(wpi.getTermsInfos());
            existWpi.boost += wpi.getBoost();
            return;
        }
        this.getPhraseList().add(wpi);
    }

    public static class WeightedPhraseInfo
    implements Comparable<WeightedPhraseInfo> {
        private List<Toffs> termsOffsets;
        private float boost;
        private int seqnum;
        private ArrayList<FieldTermStack.TermInfo> termsInfos;

        public String getText() {
            StringBuilder text = new StringBuilder();
            for (FieldTermStack.TermInfo ti : this.termsInfos) {
                text.append(ti.getText());
            }
            return text.toString();
        }

        public List<Toffs> getTermsOffsets() {
            return this.termsOffsets;
        }

        public float getBoost() {
            return this.boost;
        }

        public List<FieldTermStack.TermInfo> getTermsInfos() {
            return this.termsInfos;
        }

        public WeightedPhraseInfo(LinkedList<FieldTermStack.TermInfo> terms, float boost) {
            this(terms, boost, 0);
        }

        public WeightedPhraseInfo(LinkedList<FieldTermStack.TermInfo> terms, float boost, int seqnum) {
            this.boost = boost;
            this.seqnum = seqnum;
            this.termsInfos = new ArrayList<FieldTermStack.TermInfo>(terms);
            this.termsOffsets = new ArrayList<Toffs>(terms.size());
            FieldTermStack.TermInfo ti = terms.get(0);
            this.termsOffsets.add(new Toffs(ti.getStartOffset(), ti.getEndOffset()));
            if (terms.size() == 1) {
                return;
            }
            int pos = ti.getPosition();
            for (int i = 1; i < terms.size(); ++i) {
                ti = terms.get(i);
                if (ti.getPosition() - pos == 1) {
                    Toffs to = this.termsOffsets.get(this.termsOffsets.size() - 1);
                    to.setEndOffset(ti.getEndOffset());
                } else {
                    this.termsOffsets.add(new Toffs(ti.getStartOffset(), ti.getEndOffset()));
                }
                pos = ti.getPosition();
            }
        }

        public WeightedPhraseInfo(Collection<WeightedPhraseInfo> toMerge) {
            Iterator<WeightedPhraseInfo> toMergeItr = toMerge.iterator();
            if (!toMergeItr.hasNext()) {
                throw new IllegalArgumentException("toMerge must contain at least one WeightedPhraseInfo.");
            }
            WeightedPhraseInfo first = toMergeItr.next();
            Iterator[] allToffs = new Iterator[toMerge.size()];
            this.termsInfos = new ArrayList();
            this.seqnum = first.seqnum;
            this.boost = first.boost;
            allToffs[0] = first.termsOffsets.iterator();
            int index = 1;
            while (toMergeItr.hasNext()) {
                WeightedPhraseInfo info = toMergeItr.next();
                this.boost += info.boost;
                this.termsInfos.addAll(info.termsInfos);
                allToffs[index++] = info.termsOffsets.iterator();
            }
            MergedIterator itr = new MergedIterator(false, allToffs);
            this.termsOffsets = new ArrayList<Toffs>();
            if (!itr.hasNext()) {
                return;
            }
            Toffs work = (Toffs)itr.next();
            while (itr.hasNext()) {
                Toffs current = (Toffs)itr.next();
                if (current.startOffset <= work.endOffset) {
                    work.endOffset = Math.max(work.endOffset, current.endOffset);
                    continue;
                }
                this.termsOffsets.add(work);
                work = current;
            }
            this.termsOffsets.add(work);
        }

        public int getStartOffset() {
            return this.termsOffsets.get((int)0).startOffset;
        }

        public int getEndOffset() {
            return this.termsOffsets.get((int)(this.termsOffsets.size() - 1)).endOffset;
        }

        public boolean isOffsetOverlap(WeightedPhraseInfo other) {
            int so = this.getStartOffset();
            int eo = this.getEndOffset();
            int oso = other.getStartOffset();
            int oeo = other.getEndOffset();
            if (so <= oso && oso < eo) {
                return true;
            }
            if (so < oeo && oeo <= eo) {
                return true;
            }
            if (oso <= so && so < oeo) {
                return true;
            }
            return oso < eo && eo <= oeo;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.getText()).append('(').append(this.boost).append(")(");
            for (Toffs to : this.termsOffsets) {
                sb.append(to);
            }
            sb.append(')');
            return sb.toString();
        }

        public int getSeqnum() {
            return this.seqnum;
        }

        @Override
        public int compareTo(WeightedPhraseInfo other) {
            int diff = this.getStartOffset() - other.getStartOffset();
            if (diff != 0) {
                return diff;
            }
            diff = this.getEndOffset() - other.getEndOffset();
            if (diff != 0) {
                return diff;
            }
            return (int)Math.signum(this.getBoost() - other.getBoost());
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.getStartOffset();
            result = 31 * result + this.getEndOffset();
            long b = Double.doubleToLongBits(this.getBoost());
            result = 31 * result + (int)(b ^ b >>> 32);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            WeightedPhraseInfo other = (WeightedPhraseInfo)obj;
            if (this.getStartOffset() != other.getStartOffset()) {
                return false;
            }
            if (this.getEndOffset() != other.getEndOffset()) {
                return false;
            }
            return this.getBoost() == other.getBoost();
        }

        public static class Toffs
        implements Comparable<Toffs> {
            private int startOffset;
            private int endOffset;

            public Toffs(int startOffset, int endOffset) {
                this.startOffset = startOffset;
                this.endOffset = endOffset;
            }

            public void setEndOffset(int endOffset) {
                this.endOffset = endOffset;
            }

            public int getStartOffset() {
                return this.startOffset;
            }

            public int getEndOffset() {
                return this.endOffset;
            }

            @Override
            public int compareTo(Toffs other) {
                int diff = this.getStartOffset() - other.getStartOffset();
                if (diff != 0) {
                    return diff;
                }
                return this.getEndOffset() - other.getEndOffset();
            }

            public int hashCode() {
                int prime = 31;
                int result = 1;
                result = 31 * result + this.getStartOffset();
                result = 31 * result + this.getEndOffset();
                return result;
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                Toffs other = (Toffs)obj;
                if (this.getStartOffset() != other.getStartOffset()) {
                    return false;
                }
                return this.getEndOffset() == other.getEndOffset();
            }

            public String toString() {
                StringBuilder sb = new StringBuilder();
                sb.append('(').append(this.startOffset).append(',').append(this.endOffset).append(')');
                return sb.toString();
            }
        }
    }
}

