/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.engine;

import io.fabric8.kubernetes.api.model.ContainerState;
import io.fabric8.kubernetes.api.model.ContainerStatus;
import io.fabric8.kubernetes.api.model.Pod;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import org.apache.kyuubi.Logging;
import org.apache.kyuubi.client.util.JsonUtils;
import org.apache.kyuubi.config.KyuubiConf;
import org.apache.kyuubi.engine.ApplicationState$;
import org.apache.kyuubi.engine.KubernetesResourceEventTypes$;
import org.slf4j.Logger;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxesRunTime;

public final class KubernetesApplicationOperation$
implements Logging {
    public static KubernetesApplicationOperation$ MODULE$;
    private final String LABEL_KYUUBI_UNIQUE_KEY;
    private final String org$apache$kyuubi$engine$KubernetesApplicationOperation$$SPARK_APP_ID_LABEL;
    private final String SPARK_APP_NAME_LABEL;
    private final String KUBERNETES_SERVICE_HOST;
    private final String KUBERNETES_SERVICE_PORT;
    private final String SPARK_UI_PORT_NAME;
    private final Set<String> PENDING_WAITING_REASONS;
    private transient Logger org$apache$kyuubi$Logging$$log_;

    static {
        new KubernetesApplicationOperation$();
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public void debug(Function0<Object> message) {
        Logging.debug$((Logging)this, message);
    }

    public void debug(Function0<Object> message, Throwable t) {
        Logging.debug$((Logging)this, message, (Throwable)t);
    }

    public void info(Function0<Object> message) {
        Logging.info$((Logging)this, message);
    }

    public void info(Function0<Object> message, Throwable t) {
        Logging.info$((Logging)this, message, (Throwable)t);
    }

    public void warn(Function0<Object> message) {
        Logging.warn$((Logging)this, message);
    }

    public void warn(Function0<Object> message, Throwable t) {
        Logging.warn$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<Object> message, Throwable t) {
        Logging.error$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<Object> message) {
        Logging.error$((Logging)this, message);
    }

    public void initializeLoggerIfNecessary(boolean isInterpreter) {
        Logging.initializeLoggerIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public Logger org$apache$kyuubi$Logging$$log_() {
        return this.org$apache$kyuubi$Logging$$log_;
    }

    public void org$apache$kyuubi$Logging$$log__$eq(Logger x$1) {
        this.org$apache$kyuubi$Logging$$log_ = x$1;
    }

    public String LABEL_KYUUBI_UNIQUE_KEY() {
        return this.LABEL_KYUUBI_UNIQUE_KEY;
    }

    public String org$apache$kyuubi$engine$KubernetesApplicationOperation$$SPARK_APP_ID_LABEL() {
        return this.org$apache$kyuubi$engine$KubernetesApplicationOperation$$SPARK_APP_ID_LABEL;
    }

    private String SPARK_APP_NAME_LABEL() {
        return this.SPARK_APP_NAME_LABEL;
    }

    public String KUBERNETES_SERVICE_HOST() {
        return this.KUBERNETES_SERVICE_HOST;
    }

    public String KUBERNETES_SERVICE_PORT() {
        return this.KUBERNETES_SERVICE_PORT;
    }

    public String SPARK_UI_PORT_NAME() {
        return this.SPARK_UI_PORT_NAME;
    }

    private Set<String> PENDING_WAITING_REASONS() {
        return this.PENDING_WAITING_REASONS;
    }

    public String toLabel(String tag) {
        return new StringBuilder(8).append("label: ").append(this.LABEL_KYUUBI_UNIQUE_KEY()).append("=").append(tag).toString();
    }

    public Enumeration.Value toApplicationState(Pod pod, Enumeration.Value appStateSource, String appStateContainer, Enumeration.Value eventType) {
        return (Enumeration.Value)this.toApplicationStateAndError(pod, appStateSource, appStateContainer, eventType)._1();
    }

    public Tuple2<Enumeration.Value, Option<String>> toApplicationStateAndError(Pod pod, Enumeration.Value appStateSource, String appStateContainer, Enumeration.Value eventType) {
        boolean bl;
        Enumeration.Value value = eventType;
        Enumeration.Value value2 = KubernetesResourceEventTypes$.MODULE$.ADD();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            bl = true;
        } else {
            Enumeration.Value value4 = KubernetesResourceEventTypes$.MODULE$.UPDATE();
            Enumeration.Value value5 = value;
            bl = !(value4 != null ? !value4.equals(value5) : value5 != null);
        }
        if (bl) {
            return this.getApplicationStateAndErrorFromPod(pod, appStateSource, appStateContainer);
        }
        Enumeration.Value value6 = KubernetesResourceEventTypes$.MODULE$.DELETE();
        Enumeration.Value value7 = value;
        if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
            Tuple2<Enumeration.Value, Option<String>> tuple2 = this.getApplicationStateAndErrorFromPod(pod, appStateSource, appStateContainer);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            Enumeration.Value appState = (Enumeration.Value)tuple2._1();
            Option appError = (Option)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)appState, (Object)appError);
            Enumeration.Value appState2 = (Enumeration.Value)tuple22._1();
            Option appError2 = (Option)tuple22._2();
            if (ApplicationState$.MODULE$.isTerminated(appState2)) {
                return new Tuple2((Object)appState2, (Object)appError2);
            }
            return new Tuple2((Object)ApplicationState$.MODULE$.FAILED(), (Object)new Some((Object)new StringBuilder(15).append("Pod ").append(pod.getMetadata().getName()).append(" is deleted").toString()));
        }
        throw new MatchError((Object)value);
    }

    /*
     * Unable to fully structure code
     */
    private Tuple2<Enumeration.Value, Option<String>> getApplicationStateAndErrorFromPod(Pod pod, Enumeration.Value appStateSource, String appStateContainer) {
        podName = pod.getMetadata().getName();
        var8_5 = appStateSource;
        v0 = KyuubiConf.KubernetesApplicationStateSource$.MODULE$.CONTAINER();
        var9_6 = var8_5;
        if (!(v0 != null ? v0.equals(var9_6) == false : var9_6 != null)) {
            v1 = ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(pod.getStatus().getContainerStatuses()).asScala()).find((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$getApplicationStateAndErrorFromPod$1$adapted(java.lang.String io.fabric8.kubernetes.api.model.ContainerStatus ), (Lio/fabric8/kubernetes/api/model/ContainerStatus;)Ljava/lang/Object;)((String)appStateContainer));
        } else {
            v2 = KyuubiConf.KubernetesApplicationStateSource$.MODULE$.POD();
            var10_7 = var8_5;
            if (!(v2 != null ? v2.equals(var10_7) == false : var10_7 != null)) {
                v1 = None$.MODULE$;
            } else {
                throw new MatchError((Object)var8_5);
            }
        }
        containerStatusToBuildAppState = v1;
        podAppState = this.podStateToApplicationState(pod.getStatus().getPhase());
        containerAppStateOpt = containerStatusToBuildAppState.map((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$getApplicationStateAndErrorFromPod$2(io.fabric8.kubernetes.api.model.ContainerStatus ), (Lio/fabric8/kubernetes/api/model/ContainerStatus;)Lio/fabric8/kubernetes/api/model/ContainerState;)()).map((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$getApplicationStateAndErrorFromPod$3(io.fabric8.kubernetes.api.model.ContainerState ), (Lio/fabric8/kubernetes/api/model/ContainerState;)Lscala/Enumeration$Value;)());
        var14_11 = false;
        var15_12 = null;
        var16_13 = containerAppStateOpt;
        if (!(var16_13 instanceof Some)) ** GOTO lbl-1000
        var14_11 = true;
        var15_12 = (Some)var16_13;
        containerAppState = (Enumeration.Value)var15_12.value();
        if (ApplicationState$.MODULE$.isTerminated(containerAppState)) {
            v3 = containerAppState;
        } else if (ApplicationState$.MODULE$.isTerminated(podAppState)) {
            v3 = podAppState;
        } else if (var14_11) {
            v3 = containerAppState = (Enumeration.Value)var15_12.value();
        } else if (None$.MODULE$.equals(var16_13)) {
            v3 = podAppState;
        } else {
            throw new MatchError((Object)var16_13);
        }
        applicationState = v3;
        if (ApplicationState$.MODULE$.isFailed(applicationState)) {
            errorMap = (scala.collection.immutable.Map)containerStatusToBuildAppState.map((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$getApplicationStateAndErrorFromPod$4(java.lang.String io.fabric8.kubernetes.api.model.Pod java.lang.String io.fabric8.kubernetes.api.model.ContainerStatus ), (Lio/fabric8/kubernetes/api/model/ContainerStatus;)Lscala/collection/immutable/Map;)((String)podName, (Pod)pod, (String)appStateContainer)).getOrElse((Function0)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$getApplicationStateAndErrorFromPod$5(java.lang.String io.fabric8.kubernetes.api.model.Pod ), ()Lscala/collection/immutable/Map;)((String)podName, (Pod)pod));
            v4 = new Some((Object)JsonUtils.toPrettyJson((Object)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)errorMap).asJava()));
        } else {
            v4 = None$.MODULE$;
        }
        applicationError = v4;
        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)applicationState), (Object)applicationError);
    }

    public Enumeration.Value containerStateToApplicationState(ContainerState containerState) {
        if (containerState.getWaiting() != null) {
            Option reasonOpt = Option$.MODULE$.apply((Object)containerState.getWaiting().getReason()).map((Function1 & Serializable & scala.Serializable)x$16 -> x$16.trim()).filter((Function1 & Serializable & scala.Serializable)x$17 -> BoxesRunTime.boxToBoolean((boolean)KubernetesApplicationOperation$.$anonfun$containerStateToApplicationState$2(x$17)));
            if (reasonOpt.isEmpty() || this.PENDING_WAITING_REASONS().contains(reasonOpt.get())) {
                return ApplicationState$.MODULE$.PENDING();
            }
            return ApplicationState$.MODULE$.FAILED();
        }
        if (containerState.getRunning() != null) {
            return ApplicationState$.MODULE$.RUNNING();
        }
        if (containerState.getTerminated() == null) {
            return ApplicationState$.MODULE$.UNKNOWN();
        }
        if (BoxesRunTime.equalsNumObject((Number)containerState.getTerminated().getExitCode(), (Object)BoxesRunTime.boxToInteger((int)0))) {
            return ApplicationState$.MODULE$.FINISHED();
        }
        return ApplicationState$.MODULE$.FAILED();
    }

    public Enumeration.Value podStateToApplicationState(String podState) {
        String string = podState;
        if ("Pending".equals(string)) {
            return ApplicationState$.MODULE$.PENDING();
        }
        if ("Running".equals(string)) {
            return ApplicationState$.MODULE$.RUNNING();
        }
        if ("Succeeded".equals(string)) {
            return ApplicationState$.MODULE$.FINISHED();
        }
        if ("Failed".equals(string) ? true : "Error".equals(string)) {
            return ApplicationState$.MODULE$.FAILED();
        }
        if ("OOMKilled".equals(string)) {
            return ApplicationState$.MODULE$.KILLED();
        }
        if ("Unknown".equals(string)) {
            return ApplicationState$.MODULE$.UNKNOWN();
        }
        this.warn((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(85).append("The spark driver pod state: ").append(podState).append(" is not supported, ").append("mark the application state as UNKNOWN.").toString());
        return ApplicationState$.MODULE$.UNKNOWN();
    }

    public String buildSparkAppUrl(String sparkAppUrlPattern, String sparkAppId, String sparkDriverSvc, String kubernetesContext, String kubernetesNamespace, int sparkUiPort) {
        return sparkAppUrlPattern.replace("{{SPARK_APP_ID}}", sparkAppId).replace("{{SPARK_DRIVER_SVC}}", sparkDriverSvc).replace("{{KUBERNETES_CONTEXT}}", kubernetesContext).replace("{{KUBERNETES_NAMESPACE}}", kubernetesNamespace).replace("{{SPARK_UI_PORT}}", Integer.toString(sparkUiPort));
    }

    public String getPodAppId(Pod pod) {
        return (String)pod.getMetadata().getLabels().get(this.org$apache$kyuubi$engine$KubernetesApplicationOperation$$SPARK_APP_ID_LABEL());
    }

    public String getPodAppName(Pod pod) {
        return (String)Option$.MODULE$.apply(pod.getMetadata().getLabels().get(this.SPARK_APP_NAME_LABEL())).getOrElse((Function0 & Serializable & scala.Serializable)() -> pod.getMetadata().getName());
    }

    public static final /* synthetic */ ContainerState $anonfun$getApplicationStateAndErrorFromPod$2(ContainerStatus x$15) {
        return x$15.getState();
    }

    public static final /* synthetic */ Enumeration.Value $anonfun$getApplicationStateAndErrorFromPod$3(ContainerState containerState) {
        return MODULE$.containerStateToApplicationState(containerState);
    }

    public static final /* synthetic */ scala.collection.immutable.Map $anonfun$getApplicationStateAndErrorFromPod$4(String podName$2, Pod pod$4, String appStateContainer$1, ContainerStatus cs) {
        return (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Pod"), (Object)podName$2), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"PodStatus"), (Object)pod$4.getStatus()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Container"), (Object)appStateContainer$1), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ContainerStatus"), (Object)cs)}));
    }

    public static final /* synthetic */ scala.collection.immutable.Map $anonfun$getApplicationStateAndErrorFromPod$5(String podName$2, Pod pod$4) {
        return (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Pod"), (Object)podName$2), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"PodStatus"), (Object)pod$4.getStatus())}));
    }

    public static final /* synthetic */ boolean $anonfun$containerStateToApplicationState$2(String x$17) {
        return new StringOps(Predef$.MODULE$.augmentString(x$17)).nonEmpty();
    }

    private KubernetesApplicationOperation$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
        this.LABEL_KYUUBI_UNIQUE_KEY = "kyuubi-unique-tag";
        this.org$apache$kyuubi$engine$KubernetesApplicationOperation$$SPARK_APP_ID_LABEL = "spark-app-selector";
        this.SPARK_APP_NAME_LABEL = "spark-app-name";
        this.KUBERNETES_SERVICE_HOST = "KUBERNETES_SERVICE_HOST";
        this.KUBERNETES_SERVICE_PORT = "KUBERNETES_SERVICE_PORT";
        this.SPARK_UI_PORT_NAME = "spark-ui";
        this.PENDING_WAITING_REASONS = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"ContainerCreating", "PodInitializing"}));
    }

    public static final /* synthetic */ Object $anonfun$getApplicationStateAndErrorFromPod$1$adapted(String appStateContainer$1, ContainerStatus cs) {
        return BoxesRunTime.boxToBoolean((boolean)appStateContainer$1.equalsIgnoreCase(cs.getName()));
    }
}

