/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.engine.flink;

import java.io.File;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Options;
import org.apache.flink.api.common.JobID;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.fs.Path;
import org.apache.flink.runtime.util.EnvironmentInformation;
import org.apache.flink.table.client.SqlClientException;
import org.apache.flink.table.client.cli.CliOptionsParser;
import org.apache.flink.table.gateway.service.context.DefaultContext;
import org.apache.flink.table.gateway.service.context.SessionContext;
import org.apache.flink.table.gateway.service.result.ResultFetcher;
import org.apache.flink.table.gateway.service.session.Session;
import org.apache.flink.util.JarUtils;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.kyuubi.KyuubiException;
import org.apache.kyuubi.KyuubiException$;
import org.apache.kyuubi.Logging;
import org.apache.kyuubi.util.KyuubiHadoopUtils$;
import org.apache.kyuubi.util.SemanticVersion;
import org.apache.kyuubi.util.SemanticVersion$;
import org.apache.kyuubi.util.reflect.ReflectUtils$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.SetLike;
import scala.collection.convert.ImplicitConversions$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class FlinkEngineUtils$
implements Logging {
    public static FlinkEngineUtils$ MODULE$;
    private final Options EMBEDDED_MODE_CLIENT_OPTIONS;
    private final SemanticVersion FLINK_RUNTIME_VERSION;
    private transient Logger org$apache$kyuubi$Logging$$log_;

    static {
        new FlinkEngineUtils$();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public Logger logger() {
        return Logging.logger$(this);
    }

    @Override
    public void debug(Function0<Object> message) {
        Logging.debug$(this, message);
    }

    @Override
    public void debug(Function0<Object> message, Throwable t) {
        Logging.debug$(this, message, t);
    }

    @Override
    public void info(Function0<Object> message) {
        Logging.info$(this, message);
    }

    @Override
    public void info(Function0<Object> message, Throwable t) {
        Logging.info$(this, message, t);
    }

    @Override
    public void warn(Function0<Object> message) {
        Logging.warn$(this, message);
    }

    @Override
    public void warn(Function0<Object> message, Throwable t) {
        Logging.warn$(this, message, t);
    }

    @Override
    public void error(Function0<Object> message, Throwable t) {
        Logging.error$(this, message, t);
    }

    @Override
    public void error(Function0<Object> message) {
        Logging.error$(this, message);
    }

    @Override
    public void initializeLoggerIfNecessary(boolean isInterpreter) {
        Logging.initializeLoggerIfNecessary$(this, isInterpreter);
    }

    @Override
    public Logger org$apache$kyuubi$Logging$$log_() {
        return this.org$apache$kyuubi$Logging$$log_;
    }

    @Override
    public void org$apache$kyuubi$Logging$$log__$eq(Logger x$1) {
        this.org$apache$kyuubi$Logging$$log_ = x$1;
    }

    public Options EMBEDDED_MODE_CLIENT_OPTIONS() {
        return this.EMBEDDED_MODE_CLIENT_OPTIONS;
    }

    private Set<SemanticVersion> SUPPORTED_FLINK_VERSIONS() {
        return (Set)((SetLike)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1.17", "1.18", "1.19", "1.20"}))).map((Function1 & Serializable & scala.Serializable)versionString -> SemanticVersion$.MODULE$.apply((String)versionString), Set$.MODULE$.canBuildFrom());
    }

    public SemanticVersion FLINK_RUNTIME_VERSION() {
        return this.FLINK_RUNTIME_VERSION;
    }

    public void checkFlinkVersion() {
        String flinkVersion = EnvironmentInformation.getVersion();
        if (this.SUPPORTED_FLINK_VERSIONS().contains((Object)this.FLINK_RUNTIME_VERSION())) {
            this.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(29).append("The current Flink version is ").append(flinkVersion).toString());
            return;
        }
        throw new UnsupportedOperationException(new StringBuilder(72).append("You are using unsupported Flink version ").append(flinkVersion).append(", ").append("only Flink ").append(this.SUPPORTED_FLINK_VERSIONS().mkString(", ")).append(" are supported now.").toString());
    }

    private List<URL> discoverDependencies(List<URL> jars, List<URL> libraries) {
        ArrayList<URL> dependencies = new ArrayList<URL>();
        try {
            ImplicitConversions$.MODULE$.list$u0020asScalaBuffer(jars).foreach((Function1 & Serializable & scala.Serializable)url -> BoxesRunTime.boxToBoolean((boolean)FlinkEngineUtils$.$anonfun$discoverDependencies$1(dependencies, url)));
            ImplicitConversions$.MODULE$.list$u0020asScalaBuffer(libraries).foreach((Function1 & Serializable & scala.Serializable)libUrl -> {
                FlinkEngineUtils$.$anonfun$discoverDependencies$2(dependencies, libUrl);
                return BoxedUnit.UNIT;
            });
        }
        catch (Exception e) {
            throw new SqlClientException("Could not load all required JAR files.", (Throwable)e);
        }
        return dependencies;
    }

    public DefaultContext getDefaultContext(String[] args, Configuration flinkConf, String flinkConfDir) {
        DefaultParser parser = new DefaultParser();
        CommandLine line = parser.parse(this.EMBEDDED_MODE_CLIENT_OPTIONS(), args, true);
        List jars = (List)Option$.MODULE$.apply(this.checkUrls(line, CliOptionsParser.OPTION_JAR)).getOrElse((Function0 & Serializable & scala.Serializable)() -> Collections.emptyList());
        List libDirs = (List)Option$.MODULE$.apply(this.checkUrls(line, CliOptionsParser.OPTION_LIBRARY)).getOrElse((Function0 & Serializable & scala.Serializable)() -> Collections.emptyList());
        List<URL> dependencies = this.discoverDependencies(jars, libDirs);
        if (this.FLINK_RUNTIME_VERSION().$greater$eq("1.19")) {
            return (DefaultContext)ReflectUtils$.MODULE$.invokeAs(DefaultContext.class, "load", (Seq<Tuple2<Class<?>, Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2(Configuration.class, (Object)flinkConf), new Tuple2(List.class, dependencies), new Tuple2(Boolean.TYPE, (Object)Boolean.TRUE)}));
        }
        if (this.FLINK_RUNTIME_VERSION().$greater$eq("1.17")) {
            return (DefaultContext)ReflectUtils$.MODULE$.invokeAs(DefaultContext.class, "load", (Seq<Tuple2<Class<?>, Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2(Configuration.class, (Object)flinkConf), new Tuple2(List.class, dependencies), new Tuple2(Boolean.TYPE, (Object)Boolean.TRUE), new Tuple2(Boolean.TYPE, (Object)Boolean.FALSE)}));
        }
        throw new KyuubiException(new StringBuilder(43).append("Flink version ").append(EnvironmentInformation.getVersion()).append(" are not supported currently.").toString(), KyuubiException$.MODULE$.$lessinit$greater$default$2());
    }

    public SessionContext getSessionContext(Session session) {
        return (SessionContext)ReflectUtils$.MODULE$.getField(session, "sessionContext");
    }

    public Option<JobID> getResultJobId(ResultFetcher resultFetch) {
        None$ none$;
        try {
            none$ = Option$.MODULE$.apply(ReflectUtils$.MODULE$.getField(resultFetch, "jobID"));
        }
        catch (NullPointerException nullPointerException) {
            none$ = None$.MODULE$;
        }
        catch (Throwable e) {
            throw new IllegalStateException("Unexpected error occurred while fetching query ID", e);
        }
        return none$;
    }

    public String checkSessionId(CommandLine line) {
        String sessionId = line.getOptionValue(CliOptionsParser.OPTION_SESSION.getOpt());
        if (sessionId != null && !sessionId.matches("[a-zA-Z0-9_\\-.]+")) {
            throw new SqlClientException("Session identifier must only consists of 'a-zA-Z0-9_-.'.");
        }
        return sessionId;
    }

    public URL checkUrl(CommandLine line, org.apache.commons.cli.Option option) {
        List<URL> urls = this.checkUrls(line, option);
        if (urls != null && ImplicitConversions$.MODULE$.list$u0020asScalaBuffer(urls).nonEmpty()) {
            return (URL)ImplicitConversions$.MODULE$.list$u0020asScalaBuffer(urls).head();
        }
        return null;
    }

    public List<URL> checkUrls(CommandLine line, org.apache.commons.cli.Option option) {
        if (line.hasOption(option.getOpt())) {
            return ImplicitConversions$.MODULE$.seq$u0020AsJavaList((Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])line.getOptionValues(option.getOpt()))).distinct())).map((Function1 & Serializable & scala.Serializable)url -> {
                URL uRL;
                CliOptionsParser.checkFilePath((String)url);
                try {
                    uRL = Path.fromLocalFile((File)new File((String)url).getAbsoluteFile()).toUri().toURL();
                }
                catch (Exception e) {
                    throw new SqlClientException(new StringBuilder(28).append("Invalid path for option '").append(option.getLongOpt()).append("': ").append((String)url).toString(), (Throwable)e);
                }
                return uRL;
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(URL.class))))).toList());
        }
        return null;
    }

    public void renewDelegationToken(String delegationToken) {
        Credentials newCreds = KyuubiHadoopUtils$.MODULE$.decodeCredentials(delegationToken);
        Map<Text, Token<? extends TokenIdentifier>> newTokens = KyuubiHadoopUtils$.MODULE$.getTokenMap(newCreds);
        Credentials updateCreds = new Credentials();
        Credentials oldCreds = UserGroupInformation.getCurrentUser().getCredentials();
        newTokens.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            FlinkEngineUtils$.$anonfun$renewDelegationToken$1(oldCreds, updateCreds, x0$1);
            return BoxedUnit.UNIT;
        });
        if (updateCreds.numberOfTokens() > 0) {
            this.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(111).append("Update delegation tokens. ").append("The number of tokens sent by the server is ").append(newCreds.numberOfTokens()).append(". ").append("The actual number of updated tokens is ").append(updateCreds.numberOfTokens()).append(".").toString());
            UserGroupInformation.getCurrentUser().addCredentials(updateCreds);
            return;
        }
    }

    public static final /* synthetic */ boolean $anonfun$discoverDependencies$1(List dependencies$1, URL url) {
        JarUtils.checkJarFile((URL)url);
        return dependencies$1.add(url);
    }

    public static final /* synthetic */ boolean $anonfun$discoverDependencies$3(File f) {
        return f.isFile() && f.getAbsolutePath().toLowerCase().endsWith(".jar");
    }

    public static final /* synthetic */ boolean $anonfun$discoverDependencies$4(List dependencies$1, File f) {
        URL url = f.toURI().toURL();
        JarUtils.checkJarFile((URL)url);
        return dependencies$1.add(url);
    }

    public static final /* synthetic */ void $anonfun$discoverDependencies$2(List dependencies$1, URL libUrl) {
        File dir = new File(libUrl.toURI());
        if (!dir.isDirectory()) {
            throw new SqlClientException(new StringBuilder(20).append("Directory expected: ").append(dir).toString());
        }
        if (!dir.canRead()) {
            throw new SqlClientException(new StringBuilder(26).append("Directory cannot be read: ").append(dir).toString());
        }
        File[] files = dir.listFiles();
        if (files == null) {
            throw new SqlClientException(new StringBuilder(26).append("Directory cannot be read: ").append(dir).toString());
        }
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])files)).filter((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)FlinkEngineUtils$.$anonfun$discoverDependencies$3(f))))).foreach((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)FlinkEngineUtils$.$anonfun$discoverDependencies$4(dependencies$1, f)));
    }

    public static final /* synthetic */ void $anonfun$renewDelegationToken$1(Credentials oldCreds$1, Credentials updateCreds$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            Text alias = (Text)tuple2._1();
            Token newToken = (Token)tuple2._2();
            Token oldToken = oldCreds$1.getToken(alias);
            if (oldToken != null) {
                if (KyuubiHadoopUtils$.MODULE$.compareIssueDate((Token<? extends TokenIdentifier>)newToken, (Token<? extends TokenIdentifier>)oldToken) > 0) {
                    updateCreds$1.addToken(alias, newToken);
                    return;
                }
                MODULE$.warn((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(38).append("Ignore token with earlier issue date: ").append(newToken).toString());
                return;
            }
            MODULE$.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(22).append("Add new unknown token ").append(newToken).toString());
            updateCreds$1.addToken(alias, newToken);
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    private FlinkEngineUtils$() {
        MODULE$ = this;
        Logging.$init$(this);
        this.EMBEDDED_MODE_CLIENT_OPTIONS = CliOptionsParser.getEmbeddedModeClientOptions((Options)new Options());
        this.FLINK_RUNTIME_VERSION = SemanticVersion$.MODULE$.apply(EnvironmentInformation.getVersion());
    }
}

