/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.util;

import java.io.File;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaUtils {
    private static final Logger LOG = LoggerFactory.getLogger(JavaUtils.class);
    public static final boolean isWindows = System.getProperty("os.name", "").startsWith("Windows");
    public static final boolean isMac = System.getProperty("os.name", "").startsWith("Mac");

    public static String getCodeSourceLocation(Class<?> clazz) {
        try {
            return new File(clazz.getProtectionDomain().getCodeSource().getLocation().toURI()).getPath();
        }
        catch (URISyntaxException rethrow) {
            throw new RuntimeException(rethrow);
        }
    }

    public static InetAddress findLocalInetAddress() throws UnknownHostException, SocketException {
        InetAddress address = InetAddress.getLocalHost();
        if (address.isLoopbackAddress()) {
            ArrayList<NetworkInterface> activeNetworkIFs = Collections.list(NetworkInterface.getNetworkInterfaces());
            if (!isWindows) {
                Collections.reverse(activeNetworkIFs);
            }
            for (NetworkInterface ni : activeNetworkIFs) {
                List addresses = Collections.list(ni.getInetAddresses()).stream().filter(addr -> !addr.isLinkLocalAddress() && !addr.isLoopbackAddress()).collect(Collectors.toList());
                if (addresses.isEmpty()) continue;
                InetAddress addr2 = addresses.stream().filter(a -> a instanceof Inet4Address).findFirst().orElse((InetAddress)addresses.get(0));
                InetAddress strippedAddress = InetAddress.getByAddress(addr2.getAddress());
                LOG.warn("{} was resolved to a loopback address: {}, using {}", new Object[]{addr2.getHostName(), addr2.getHostAddress(), strippedAddress.getHostAddress()});
                return strippedAddress;
            }
            LOG.warn("{} was resolved to a loopback address: {} but we couldn't find any external IP address!", (Object)address.getHostName(), (Object)address.getHostAddress());
        }
        return address;
    }
}

