/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.tx.control.service.xa.impl;

import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import org.apache.aries.tx.control.service.xa.impl.TransactionControlImpl;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.ManagedService;
import org.osgi.service.transaction.control.TransactionControl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Activator
implements BundleActivator {
    static final String PID = "org.apache.aries.tx.control.service.xa";
    private static final Logger logger = LoggerFactory.getLogger(Activator.class);
    private ServiceRegistration<ManagedService> msReg;
    private boolean open;
    private TransactionControlImpl txControlImpl;
    private ServiceRegistration<TransactionControl> txControlReg;
    private Map<String, Object> configuration;
    private BundleContext context;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(BundleContext context) throws Exception {
        this.context = context;
        Activator activator = this;
        synchronized (activator) {
            this.open = true;
        }
        Dictionary<String, Object> properties = this.getMSProperties();
        logger.info("Registering for configuration updates {}", properties);
        ManagedService service = c -> this.configurationUpdated(c, false);
        this.msReg = context.registerService(ManagedService.class, (Object)service, properties);
        new Thread(() -> {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
            }
            this.configurationUpdated(null, true);
        }).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(BundleContext context) throws Exception {
        TransactionControlImpl toClose;
        ServiceRegistration<TransactionControl> toUnregister;
        this.safeUnregister(this.msReg);
        Activator activator = this;
        synchronized (activator) {
            this.open = false;
            toUnregister = this.txControlReg;
            this.txControlReg = null;
            toClose = this.txControlImpl;
            this.txControlImpl = null;
            this.configuration = null;
        }
        this.cleanUp(toUnregister, toClose);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void configurationUpdated(Dictionary<String, ?> config, boolean internal) {
        Runnable action;
        Map<String, Object> newConfig = this.toMap(config);
        Activator activator = this;
        synchronized (activator) {
            if (!this.open) {
                return;
            }
            if (internal && this.configuration != null) {
                return;
            }
            ChangeType change = this.txControlImpl == null ? ChangeType.RECREATE : this.txControlImpl.changed(newConfig, this.txControlReg == null);
            switch (change) {
                case NONE: {
                    action = () -> {};
                    break;
                }
                case SERVICE_PROPS: {
                    ServiceRegistration<TransactionControl> toUpdate = this.txControlReg;
                    TransactionControlImpl implToQuery = this.txControlImpl;
                    action = () -> toUpdate.setProperties(implToQuery.getProperties());
                    break;
                }
                case RECREATE: {
                    ServiceRegistration<TransactionControl> toUnregister = this.txControlReg;
                    TransactionControlImpl toClose = this.txControlImpl;
                    this.txControlReg = null;
                    this.txControlImpl = null;
                    action = () -> {
                        ServiceRegistration newReg;
                        TransactionControlImpl impl;
                        block8: {
                            this.cleanUp(toUnregister, toClose);
                            impl = null;
                            newReg = null;
                            try {
                                impl = new TransactionControlImpl(this.context, newConfig);
                                newReg = this.context.registerService(TransactionControl.class, (Object)impl, impl.getProperties());
                            }
                            catch (Exception e) {
                                if (newReg != null) {
                                    this.safeUnregister(newReg);
                                }
                                if (impl == null) break block8;
                                impl.close();
                            }
                        }
                        boolean cleanUp = true;
                        Activator activator = this;
                        synchronized (activator) {
                            if (this.configuration == newConfig && this.open) {
                                this.txControlImpl = impl;
                                this.txControlReg = newReg;
                                cleanUp = false;
                            }
                        }
                        if (cleanUp) {
                            this.cleanUp((ServiceRegistration<TransactionControl>)newReg, impl);
                        }
                    };
                    break;
                }
                default: {
                    throw new IllegalArgumentException("An unknown change occurred " + (Object)((Object)change));
                }
            }
            this.configuration = newConfig;
        }
        action.run();
    }

    private void cleanUp(ServiceRegistration<TransactionControl> toUnregister, TransactionControlImpl toClose) {
        this.safeUnregister(toUnregister);
        if (toClose != null) {
            toClose.close();
        }
    }

    private void safeUnregister(ServiceRegistration<?> reg) {
        if (reg != null) {
            try {
                reg.unregister();
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
    }

    private Map<String, Object> toMap(Dictionary<String, ?> config) {
        HashMap<String, Object> configMap = new HashMap<String, Object>();
        if (config != null) {
            Enumeration<String> keys = config.keys();
            while (keys.hasMoreElements()) {
                String key = keys.nextElement();
                configMap.put(key, config.get(key));
            }
        }
        return configMap;
    }

    private Dictionary<String, Object> getMSProperties() {
        Hashtable<String, Object> props = new Hashtable<String, Object>();
        ((Dictionary)props).put("service.pid", PID);
        ((Dictionary)props).put("service.description", "Managed Service for the Apache Aries Transaction Control Service with XA Transactions");
        ((Dictionary)props).put("service.vendor", "Apache Aries");
        return props;
    }

    public static enum ChangeType {
        NONE,
        SERVICE_PROPS,
        RECREATE;

    }
}

