/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.streams.query.Position;

public final class PositionSerde {
    public static Position deserialize(ByteBuffer buffer) {
        byte version = buffer.get();
        switch (version) {
            case 0: {
                int nTopics = buffer.getInt();
                HashMap position = new HashMap(nTopics);
                for (int i = 0; i < nTopics; ++i) {
                    int topicNameLength = buffer.getInt();
                    byte[] topicNameBytes = new byte[topicNameLength];
                    buffer.get(topicNameBytes);
                    String topic = new String(topicNameBytes, StandardCharsets.UTF_8);
                    int numPairs = buffer.getInt();
                    HashMap<Integer, Long> partitionOffsets = new HashMap<Integer, Long>(numPairs);
                    for (int j = 0; j < numPairs; ++j) {
                        partitionOffsets.put(buffer.getInt(), buffer.getLong());
                    }
                    position.put(topic, partitionOffsets);
                }
                return Position.fromMap(position);
            }
        }
        throw new IllegalArgumentException("Unknown version " + version + " when deserializing Position");
    }

    public static ByteBuffer serialize(Position position) {
        Map<Integer, Long> partitionOffsets;
        boolean version = false;
        int arraySize = 8;
        int nTopics = position.getTopics().size();
        arraySize += 32;
        ArrayList<String> entries = new ArrayList<String>(position.getTopics());
        byte[][] topics = new byte[entries.size()][];
        for (int i = 0; i < nTopics; ++i) {
            String topic = entries.get(i);
            byte[] topicBytes = topic.getBytes(StandardCharsets.UTF_8);
            topics[i] = topicBytes;
            arraySize += 32;
            arraySize += topicBytes.length;
            partitionOffsets = position.getPartitionPositions(topic);
            arraySize += 32;
            arraySize += 96 * partitionOffsets.size();
        }
        ByteBuffer buffer = ByteBuffer.allocate(arraySize);
        buffer.put((byte)0);
        buffer.putInt(nTopics);
        for (int i = 0; i < nTopics; ++i) {
            buffer.putInt(topics[i].length);
            buffer.put(topics[i]);
            String topic = entries.get(i);
            partitionOffsets = position.getPartitionPositions(topic);
            buffer.putInt(partitionOffsets.size());
            for (Map.Entry<Integer, Long> partitionOffset : partitionOffsets.entrySet()) {
                buffer.putInt(partitionOffset.getKey());
                buffer.putLong(partitionOffset.getValue());
            }
        }
        buffer.flip();
        return buffer;
    }
}

