/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.http.part;

import java.util.function.Supplier;
import org.apache.juneau.commons.utils.ThrowableUtils;
import org.apache.juneau.commons.utils.Utils;
import org.apache.juneau.http.header.SerializedHeader;
import org.apache.juneau.http.part.BasicPart;
import org.apache.juneau.httppart.HttpPartSchema;
import org.apache.juneau.httppart.HttpPartSerializer;
import org.apache.juneau.httppart.HttpPartSerializerSession;
import org.apache.juneau.httppart.HttpPartType;
import org.apache.juneau.httppart.SchemaValidationException;
import org.apache.juneau.serializer.SerializeException;

public class SerializedPart
extends BasicPart {
    private final Object value;
    private HttpPartType type;
    private HttpPartSerializerSession serializer;
    private HttpPartSchema schema = HttpPartSchema.DEFAULT;
    private boolean skipIfEmpty;

    public static SerializedPart of(String name, Object value) {
        return new SerializedPart(name, value, null, null, null, false);
    }

    public static SerializedPart of(String name, Supplier<?> value) {
        return new SerializedPart(name, value, null, null, null, false);
    }

    public SerializedPart(String name, Object value, HttpPartType type, HttpPartSerializerSession serializer, HttpPartSchema schema, boolean skipIfEmpty) {
        super(name, value);
        this.value = value;
        this.type = type;
        this.serializer = serializer;
        this.schema = schema;
        this.skipIfEmpty = skipIfEmpty;
    }

    protected SerializedPart(SerializedPart copyFrom) {
        super(copyFrom);
        this.value = copyFrom.value;
        this.type = copyFrom.type;
        this.serializer = copyFrom.serializer == null ? this.serializer : copyFrom.serializer;
        this.schema = copyFrom.schema == null ? this.schema : copyFrom.schema;
        this.skipIfEmpty = copyFrom.skipIfEmpty;
    }

    @Override
    public SerializedHeader asHeader() {
        return new SerializedHeader(this.getName(), this.value, this.serializer, this.schema, this.skipIfEmpty);
    }

    public SerializedPart copy() {
        return new SerializedPart(this);
    }

    public SerializedPart copyWith(HttpPartSerializerSession serializer, HttpPartSchema schema) {
        if (this.serializer == null && Utils.nn((Object)serializer) || this.schema == null && Utils.nn((Object)schema)) {
            SerializedPart p = this.copy();
            if (Utils.nn((Object)serializer)) {
                p.serializer(serializer);
            }
            if (Utils.nn((Object)schema)) {
                p.schema(schema);
            }
            return p;
        }
        return this;
    }

    @Override
    public String getValue() {
        try {
            Object v = SerializedPart.unwrap(this.value);
            HttpPartSchema schema = this.schema == null ? HttpPartSchema.DEFAULT : this.schema;
            String def = schema.getDefault();
            if (v == null && (def == null && !schema.isRequired() || def == null && schema.isAllowEmptyValue())) {
                return null;
            }
            if (Utils.e((CharSequence)Utils.s((Object)v)) && this.skipIfEmpty && def == null) {
                return null;
            }
            return this.serializer == null ? Utils.s((Object)v) : this.serializer.serialize(this.type, schema, v);
        }
        catch (SchemaValidationException e) {
            throw ThrowableUtils.rex((Throwable)e, (String)"Validation error on request {0} part ''{1}''=''{2}''", (Object[])new Object[]{this.type, this.getName(), this.value});
        }
        catch (SerializeException e) {
            throw ThrowableUtils.rex((Throwable)e, (String)"Serialization error on request {0} part ''{1}''", (Object[])new Object[]{this.type, this.getName()});
        }
    }

    public SerializedPart schema(HttpPartSchema value) {
        this.schema = value;
        return this;
    }

    public SerializedPart serializer(HttpPartSerializer value) {
        if (Utils.nn((Object)value)) {
            return this.serializer(value.getPartSession());
        }
        return this;
    }

    public SerializedPart serializer(HttpPartSerializerSession value) {
        this.serializer = value;
        return this;
    }

    public SerializedPart skipIfEmpty() {
        return this.skipIfEmpty(true);
    }

    public SerializedPart skipIfEmpty(boolean value) {
        this.skipIfEmpty = value;
        return this;
    }

    public SerializedPart type(HttpPartType value) {
        this.type = value;
        return this;
    }

    private static Object unwrap(Object o) {
        if (o instanceof Supplier) {
            Supplier o2 = (Supplier)o;
            return o2.get();
        }
        return o;
    }
}

