/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.debug;

import java.util.Map;
import java.util.Objects;
import org.apache.juneau.Enablement;
import org.apache.juneau.commons.reflect.AnnotationInfo;
import org.apache.juneau.commons.reflect.AnnotationProvider;
import org.apache.juneau.commons.reflect.AnnotationTraversal;
import org.apache.juneau.commons.reflect.ClassInfo;
import org.apache.juneau.commons.reflect.MethodInfo;
import org.apache.juneau.commons.utils.CollectionUtils;
import org.apache.juneau.commons.utils.StringUtils;
import org.apache.juneau.commons.utils.Utils;
import org.apache.juneau.cp.BeanStore;
import org.apache.juneau.rest.ResourceSupplier;
import org.apache.juneau.rest.RestContext;
import org.apache.juneau.rest.annotation.Rest;
import org.apache.juneau.rest.annotation.RestOpAnnotation;
import org.apache.juneau.rest.debug.DebugEnablement;
import org.apache.juneau.rest.util.DefaultSettingsMap;
import org.apache.juneau.svl.VarResolver;

public class BasicDebugEnablement
extends DebugEnablement {
    private static final AnnotationProvider AP = AnnotationProvider.INSTANCE;

    public BasicDebugEnablement(BeanStore beanStore) {
        super(beanStore);
    }

    @Override
    protected DebugEnablement.Builder init(BeanStore beanStore) {
        DebugEnablement.Builder b = super.init(beanStore);
        DefaultSettingsMap defaultSettings = beanStore.getBean(DefaultSettingsMap.class).get();
        RestContext.Builder builder = beanStore.getBean(RestContext.Builder.class).get();
        ResourceSupplier resource = beanStore.getBean(ResourceSupplier.class).get();
        VarResolver varResolver = beanStore.getBean(VarResolver.class).get();
        AnnotationProvider ap = AP;
        Enablement debugDefault = defaultSettings.get(Enablement.class, "RestContext.debugDefault").orElse(builder.isDebug() ? Enablement.ALWAYS : Enablement.NEVER);
        b.defaultEnable(debugDefault);
        ClassInfo ci = ClassInfo.ofProxy(resource.get());
        CollectionUtils.rstream(ap.find(Rest.class, ci, new AnnotationTraversal[0])).map(AnnotationInfo::inner).forEach(x -> {
            String x2 = varResolver.resolve(x.debug());
            if (!x2.isEmpty()) {
                b.enable(Enablement.fromString(x2), ci.getNameFull());
            }
        });
        ci.getPublicMethods().stream().forEach(x -> CollectionUtils.rstream(ap.find((MethodInfo)x, new AnnotationTraversal[0])).filter(RestOpAnnotation.REST_OP_GROUP).flatMap(ai -> ai.getValue(String.class, "debug").stream()).filter(Utils::ne).map(varResolver::resolve).map(Enablement::fromString).filter(Objects::nonNull).forEach(e -> b.enable((Enablement)((Object)((Object)e)), x.getFullName())));
        CollectionUtils.rstream(ap.find(Rest.class, ci, new AnnotationTraversal[0])).map(AnnotationInfo::inner).forEach(x -> {
            String x2 = varResolver.resolve(x.debugOn());
            for (Map.Entry<String, String> e : StringUtils.splitMap(x2, true).entrySet()) {
                String k = e.getKey();
                String v = e.getValue();
                if (v.isEmpty()) {
                    v = "ALWAYS";
                }
                if (k.isEmpty()) continue;
                Utils.opt(Enablement.fromString(v)).ifPresent(en -> b.enable((Enablement)((Object)((Object)en)), k));
            }
        });
        return b;
    }
}

