/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.processor;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Map;
import org.apache.juneau.MediaType;
import org.apache.juneau.commons.utils.StringUtils;
import org.apache.juneau.commons.utils.Utils;
import org.apache.juneau.http.header.ContentType;
import org.apache.juneau.http.response.BasicHttpException;
import org.apache.juneau.http.response.InternalServerError;
import org.apache.juneau.http.response.NotAcceptable;
import org.apache.juneau.httppart.HttpPartSchema;
import org.apache.juneau.marshaller.Json5;
import org.apache.juneau.rest.RestOpSession;
import org.apache.juneau.rest.RestRequest;
import org.apache.juneau.rest.RestResponse;
import org.apache.juneau.rest.processor.ResponseProcessor;
import org.apache.juneau.rest.util.FinishableServletOutputStream;
import org.apache.juneau.serializer.SerializeException;
import org.apache.juneau.serializer.Serializer;
import org.apache.juneau.serializer.SerializerMatch;
import org.apache.juneau.serializer.SerializerSession;
import org.apache.juneau.serializer.WriterSerializerSession;

public class SerializedPojoProcessor
implements ResponseProcessor {
    @Override
    public int process(RestOpSession opSession) throws IOException, NotAcceptable, BasicHttpException {
        RestRequest req = opSession.getRequest();
        RestResponse res = opSession.getResponse();
        SerializerMatch sm = res.getSerializerMatch().orElse(null);
        HttpPartSchema schema = res.getContentSchema().orElse(null);
        Object o = res.getContent(Object.class);
        if (Utils.nn(sm)) {
            try {
                MediaType responseType;
                Serializer s = sm.getSerializer();
                MediaType mediaType = res.getMediaType();
                if (mediaType == null) {
                    mediaType = sm.getMediaType();
                }
                if ((responseType = s.getResponseContentType()) == null) {
                    responseType = mediaType;
                }
                if (req.isPlainText()) {
                    res.setHeader(ContentType.TEXT_PLAIN);
                } else {
                    res.setHeader(ContentType.of(responseType.toString()));
                }
                SerializerSession session = ((SerializerSession.Builder)((SerializerSession.Builder)s.createSession().properties((Map)req.getAttributes().asMap())).javaMethod(req.getOpContext().getJavaMethod()).locale(req.getLocale()).timeZone(req.getTimeZone().orElse(null)).mediaType(mediaType).apply(WriterSerializerSession.Builder.class, x -> x.streamCharset(res.getCharset()).useWhitespace(req.isPlainText() ? Boolean.valueOf(true) : null))).schema(schema).debug(req.isDebug() ? Boolean.valueOf(true) : null).uriContext(req.getUriContext()).resolver(req.getVarResolverSession()).build();
                for (Map.Entry<String, String> h : session.getResponseHeaders().entrySet()) {
                    res.addHeader(h.getKey(), h.getValue());
                }
                if (!session.isWriterSerializer()) {
                    if (req.isPlainText()) {
                        w = res.getNegotiatedWriter();
                        ByteArrayOutputStream baos = new ByteArrayOutputStream();
                        session.serialize(o, baos);
                        w.write(StringUtils.toSpacedHex(baos.toByteArray()));
                        w.flush();
                        w.finish();
                    } else {
                        FinishableServletOutputStream os = res.getNegotiatedOutputStream();
                        session.serialize(o, os);
                        os.flush();
                        os.finish();
                    }
                } else {
                    w = res.getNegotiatedWriter();
                    session.serialize(o, w);
                    w.flush();
                    w.finish();
                }
            }
            catch (SerializeException e) {
                throw new InternalServerError(e);
            }
            return 1;
        }
        if (o == null) {
            return 1;
        }
        throw new NotAcceptable("Unsupported media-type in request header ''Accept'': ''{0}''\n\tSupported media-types: {1}", req.getHeaderParam("Accept").orElse(""), Json5.of(res.getOpContext().getSerializers().getSupportedMediaTypes()));
    }
}

