/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.httppart.bean;

import java.lang.reflect.Method;
import java.util.Optional;
import org.apache.juneau.commons.reflect.MethodInfo;
import org.apache.juneau.commons.utils.Utils;
import org.apache.juneau.cp.BeanCreator;
import org.apache.juneau.httppart.HttpPartParser;
import org.apache.juneau.httppart.HttpPartSchema;
import org.apache.juneau.httppart.HttpPartSerializer;
import org.apache.juneau.httppart.HttpPartType;

public class ResponseBeanPropertyMeta {
    private final Method getter;
    private final HttpPartType partType;
    private final Optional<HttpPartSerializer> serializer;
    private final Optional<HttpPartParser> parser;
    private final HttpPartSchema schema;

    static Builder create(HttpPartType partType, HttpPartSchema schema, MethodInfo m) {
        return new Builder().partType(partType).schema(schema).getter(m.inner());
    }

    static Builder create(HttpPartType partType, MethodInfo m) {
        return new Builder().partType(partType).getter(m.inner());
    }

    ResponseBeanPropertyMeta(Builder b, Optional<HttpPartSerializer> serializer, Optional<HttpPartParser> parser) {
        this.partType = b.partType;
        this.schema = b.schema;
        this.getter = b.getter;
        this.serializer = serializer.isPresent() ? serializer : BeanCreator.of(HttpPartSerializer.class).type(this.schema.getSerializer()).execute();
        this.parser = parser.isPresent() ? parser : BeanCreator.of(HttpPartParser.class).type(this.schema.getParser()).execute();
    }

    public Method getGetter() {
        return this.getter;
    }

    public Optional<HttpPartParser> getParser() {
        return this.parser;
    }

    public Optional<String> getPartName() {
        return Utils.opt(this.schema == null ? null : this.schema.getName());
    }

    public HttpPartType getPartType() {
        return this.partType;
    }

    public HttpPartSchema getSchema() {
        return this.schema;
    }

    public Optional<HttpPartSerializer> getSerializer() {
        return this.serializer;
    }

    static class Builder {
        HttpPartType partType;
        HttpPartSchema schema = HttpPartSchema.DEFAULT;
        String name;
        Method getter;

        Builder() {
        }

        ResponseBeanPropertyMeta build(Optional<HttpPartSerializer> serializer, Optional<HttpPartParser> parser) {
            return new ResponseBeanPropertyMeta(this, serializer, parser);
        }

        Builder getter(Method value) {
            this.getter = value;
            return this;
        }

        Builder name(String value) {
            this.name = value;
            return this;
        }

        Builder partType(HttpPartType value) {
            this.partType = value;
            return this;
        }

        Builder schema(HttpPartSchema value) {
            this.schema = value;
            return this;
        }
    }
}

