/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.xml;

import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.juneau.FormattedRuntimeException;
import org.apache.juneau.annotation.Bean;
import org.apache.juneau.internal.StringUtils;

@Bean(sort=true)
public final class Namespace {
    private static final ConcurrentHashMap<String, Namespace> CACHE = new ConcurrentHashMap();
    final String key;
    final String name;
    final String uri;

    public static Namespace create(String name, String uri) {
        String key = name + ":" + uri;
        Namespace n = CACHE.get(key);
        if (n == null) {
            n = new Namespace(key, name, uri);
            Namespace n2 = CACHE.putIfAbsent(key, n);
            return n2 == null ? n : n2;
        }
        return n;
    }

    public static Namespace create(String key) {
        Namespace n = CACHE.get(key);
        if (n != null) {
            return n;
        }
        int i = key.indexOf(58);
        if (i == -1) {
            return Namespace.create(key, null);
        }
        if (key.startsWith("http://") || key.startsWith("https://")) {
            return Namespace.create(null, key);
        }
        return Namespace.create(key.substring(0, i).trim(), key.substring(i + 1).trim());
    }

    public static Namespace create(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof Namespace) {
            return (Namespace)o;
        }
        if (o instanceof CharSequence) {
            return Namespace.create(o.toString());
        }
        throw new FormattedRuntimeException("Invalid object type passed to Namespace.create(Object):  ''{0}''", o.getClass());
    }

    public static Namespace[] createArray(Object o) {
        if (o instanceof Namespace[]) {
            return (Namespace[])o;
        }
        if (o instanceof String[]) {
            String[] ss = (String[])o;
            Namespace[] n = new Namespace[ss.length];
            for (int i = 0; i < ss.length; ++i) {
                n[i] = Namespace.create(ss[i]);
            }
            return n;
        }
        if (o instanceof CharSequence) {
            String[] ss = StringUtils.split(o.toString());
            Namespace[] n = new Namespace[ss.length];
            for (int i = 0; i < ss.length; ++i) {
                n[i] = Namespace.create(ss[i]);
            }
            return n;
        }
        if (o instanceof Collection) {
            Collection c = (Collection)o;
            Namespace[] n = new Namespace[c.size()];
            int i = 0;
            for (Object o2 : c) {
                if (o2 instanceof Namespace) {
                    n[i] = (Namespace)o2;
                    continue;
                }
                if (o2 instanceof CharSequence) {
                    n[i] = Namespace.create(o2.toString());
                    continue;
                }
                throw new FormattedRuntimeException("Invalid type passed to NamespaceFactory.createArray: ''{0}''", o);
            }
            return n;
        }
        throw new FormattedRuntimeException("Invalid type passed to NamespaceFactory.createArray: ''{0}''", o);
    }

    private Namespace(String key, String name, String uri) {
        this.key = key;
        this.name = name;
        this.uri = uri;
    }

    public String getName() {
        return this.name;
    }

    public String getUri() {
        return this.uri;
    }

    public String toString() {
        return this.key;
    }
}

