/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.serializer;

import java.nio.charset.Charset;
import org.apache.juneau.DefaultFilteringObjectMap;
import org.apache.juneau.ObjectMap;
import org.apache.juneau.PropertyStore;
import org.apache.juneau.annotation.ConfigurableContext;
import org.apache.juneau.internal.IOUtils;
import org.apache.juneau.serializer.SerializeException;
import org.apache.juneau.serializer.Serializer;
import org.apache.juneau.serializer.SerializerSessionArgs;
import org.apache.juneau.serializer.WriterSerializerSession;
import org.apache.juneau.utils.StringObject;

@ConfigurableContext
public abstract class WriterSerializer
extends Serializer {
    static final String PREFIX = "WriterSerializer";
    public static final String WSERIALIZER_fileCharset = "WriterSerializer.fileCharset.s";
    public static final String WSERIALIZER_maxIndent = "WriterSerializer.maxIndent.i";
    public static final String WSERIALIZER_quoteChar = "WriterSerializer.quoteChar.s";
    public static final String WSERIALIZER_streamCharset = "WriterSerializer.streamCharset.s";
    public static final String WSERIALIZER_useWhitespace = "WriterSerializer.useWhitespace.b";
    static final WriterSerializer DEFAULT = new WriterSerializer(PropertyStore.create().build(), "", ""){

        @Override
        public WriterSerializerSession createSession(SerializerSessionArgs args) {
            throw new NoSuchMethodError();
        }
    };
    private final Charset fileCharset;
    private final int maxIndent = this.getIntegerProperty("WriterSerializer.maxIndent.i", 100);
    private final char quoteChar = this.getStringProperty("WriterSerializer.quoteChar.s", "\"").charAt(0);
    private final Charset streamCharset = this.getProperty("WriterSerializer.streamCharset.s", Charset.class, IOUtils.UTF8);
    private final boolean useWhitespace;

    protected WriterSerializer(PropertyStore ps, String produces, String accept) {
        super(ps, produces, accept);
        this.fileCharset = this.getProperty(WSERIALIZER_fileCharset, Charset.class, Charset.defaultCharset());
        this.useWhitespace = this.getBooleanProperty(WSERIALIZER_useWhitespace, false);
    }

    @Override
    public abstract WriterSerializerSession createSession(SerializerSessionArgs var1);

    @Override
    public WriterSerializerSession createSession() {
        return this.createSession(this.createDefaultSessionArgs());
    }

    @Override
    public final boolean isWriterSerializer() {
        return true;
    }

    @Override
    public final String serialize(Object o) throws SerializeException {
        return this.createSession(this.createDefaultSessionArgs()).serialize(o);
    }

    public final String toString(Object o) {
        try {
            return this.serialize(o);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public final StringObject toStringObject(Object o) {
        return new StringObject(this, o);
    }

    public final WriterSerializer println(Object o) {
        System.out.println(this.toString(o));
        return this;
    }

    protected final Charset getFileCharset() {
        return this.fileCharset;
    }

    protected final int getMaxIndent() {
        return this.maxIndent;
    }

    protected final char getQuoteChar() {
        return this.quoteChar;
    }

    protected final Charset getStreamCharset() {
        return this.streamCharset;
    }

    protected final boolean isUseWhitespace() {
        return this.useWhitespace;
    }

    @Override
    public ObjectMap toMap() {
        return super.toMap().append(PREFIX, new DefaultFilteringObjectMap().append("fileCharset", this.fileCharset).append("maxIndent", this.maxIndent).append("quoteChar", Character.valueOf(this.quoteChar)).append("streamCharset", this.streamCharset).append("useWhitespace", this.useWhitespace));
    }
}

