/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http.content;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import java.util.Objects;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.content.HttpContent;
import org.eclipse.jetty.io.Content;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.IteratingCallback;
import org.eclipse.jetty.util.IteratingNestedCallback;
import org.eclipse.jetty.util.TypeUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileMappingHttpContentFactory
implements HttpContent.Factory {
    private static final Logger LOG = LoggerFactory.getLogger(FileMappingHttpContentFactory.class);
    private static final int DEFAULT_MIN_FILE_SIZE = 0x100000;
    private static final int DEFAULT_MAX_BUFFER_SIZE = Integer.MAX_VALUE;
    private final HttpContent.Factory _factory;
    private final int _minFileSize;
    private final int _maxBufferSize;

    public FileMappingHttpContentFactory(HttpContent.Factory factory) {
        this(factory, -1, -1);
    }

    public FileMappingHttpContentFactory(HttpContent.Factory factory, int minFileSize, int maxBufferSize) {
        this._factory = Objects.requireNonNull(factory);
        this._minFileSize = minFileSize == -1 ? 0x100000 : minFileSize;
        this._maxBufferSize = maxBufferSize == -1 ? Integer.MAX_VALUE : maxBufferSize;
    }

    @Override
    public HttpContent getContent(String path) throws IOException {
        HttpContent content;
        block4: {
            content = this._factory.getContent(path);
            if (content != null) {
                try {
                    long contentLength = content.getContentLengthValue();
                    if (contentLength < (long)this._minFileSize) {
                        return content;
                    }
                    return contentLength <= (long)this._maxBufferSize ? new SingleBufferFileMappedHttpContent(content) : new MultiBufferFileMappedHttpContent(content, this._maxBufferSize);
                }
                catch (IOException e2) {
                    if (!LOG.isDebugEnabled()) break block4;
                    LOG.debug("Error getting Mapped Buffer", e2);
                }
            }
        }
        return content;
    }

    private static class SingleBufferFileMappedHttpContent
    extends HttpContent.Wrapper {
        private final ByteBuffer _buffer;
        private final HttpField _contentLength;

        private SingleBufferFileMappedHttpContent(HttpContent content) throws IOException {
            super(content);
            Path path = content.getResource().getPath();
            if (path == null) {
                throw new IOException("Cannot memory map Content whose Resource is not backed by a Path: " + String.valueOf(content.getResource()));
            }
            this._buffer = BufferUtil.toMappedBuffer(path);
            if (this._buffer == null) {
                throw new IOException("Cannot memory map Content (not supported by underlying FileSystem): " + String.valueOf(content.getResource()));
            }
            this._contentLength = new HttpField(HttpHeader.CONTENT_LENGTH, Integer.toString(this._buffer.remaining()));
        }

        @Override
        public void writeTo(Content.Sink sink, long offset, long length, Callback callback) {
            try {
                length = TypeUtil.checkOffsetLengthSize(offset, length, this._buffer.remaining());
                sink.write(true, BufferUtil.slice(this._buffer, Math.toIntExact(offset), Math.toIntExact(length)), callback);
            }
            catch (Throwable x) {
                callback.failed(x);
            }
        }

        @Override
        public HttpField getContentLength() {
            return this._contentLength;
        }

        @Override
        public long getContentLengthValue() {
            return this._buffer.remaining();
        }
    }

    private static class MultiBufferFileMappedHttpContent
    extends HttpContent.Wrapper {
        private final ByteBuffer[] _buffers;
        private final int maxBufferSize;
        private final HttpField _contentLength;
        private final long _contentLengthValue;

        private MultiBufferFileMappedHttpContent(HttpContent content, int maxBufferSize) throws IOException {
            super(content);
            this.maxBufferSize = maxBufferSize;
            Path path = content.getResource().getPath();
            if (path == null) {
                throw new IOException("Cannot memory map Content whose Resource is not backed by a Path: " + String.valueOf(content.getResource()));
            }
            long contentLength = content.getContentLengthValue();
            int bufferCount = Math.toIntExact(contentLength / (long)maxBufferSize);
            if (contentLength % (long)maxBufferSize != 0L) {
                if (bufferCount == Integer.MAX_VALUE) {
                    throw new IOException("Cannot memory map Content as that would require over Integer.MAX_VALUE buffers: " + String.valueOf(content));
                }
                ++bufferCount;
            }
            this._buffers = new ByteBuffer[bufferCount];
            long currentPos = 0L;
            long total = 0L;
            for (int i = 0; i < this._buffers.length; ++i) {
                long len = Math.min(contentLength - currentPos, (long)maxBufferSize);
                this._buffers[i] = BufferUtil.toMappedBuffer(path, currentPos, len);
                if (this._buffers[i] == null) {
                    throw new IOException("Cannot memory map Content (not supported by underlying FileSystem): " + String.valueOf(content.getResource()));
                }
                currentPos += len;
                total += (long)this._buffers[i].remaining();
            }
            this._contentLengthValue = total;
            this._contentLength = new HttpField(HttpHeader.CONTENT_LENGTH, Long.toString(total));
        }

        @Override
        public void writeTo(final Content.Sink sink, long offset, long length, Callback callback) {
            try {
                length = TypeUtil.checkOffsetLengthSize(offset, length, this._contentLengthValue);
                final int beginIndex = Math.toIntExact(offset / (long)this.maxBufferSize);
                final int firstOffset = Math.toIntExact(offset % (long)this.maxBufferSize);
                final int endIndex = this.calculateEndIndex(offset, length);
                final int lastLen = this.calculateLastLen(offset, length);
                new IteratingNestedCallback(this, callback){
                    int index;
                    final /* synthetic */ MultiBufferFileMappedHttpContent this$0;
                    {
                        this.this$0 = this$0;
                        super(arg0);
                        this.index = beginIndex;
                    }

                    @Override
                    protected IteratingCallback.Action process() {
                        if (this.index > endIndex) {
                            return IteratingCallback.Action.SUCCEEDED;
                        }
                        ByteBuffer currentBuffer = this.this$0._buffers[this.index];
                        int offset = this.index == beginIndex ? firstOffset : 0;
                        int len = this.index == endIndex ? lastLen : -1;
                        boolean last = this.index == endIndex;
                        ++this.index;
                        sink.write(last, BufferUtil.slice(currentBuffer, offset, len), this);
                        return IteratingCallback.Action.SCHEDULED;
                    }
                }.iterate();
            }
            catch (Throwable x) {
                callback.failed(x);
            }
        }

        private int calculateLastLen(long offset, long length) {
            int lastLen;
            if (length == 0L) {
                return 0;
            }
            int n = lastLen = length < 0L ? -1 : Math.toIntExact((length + offset) % (long)this.maxBufferSize);
            if (Math.toIntExact((length + offset) / (long)this.maxBufferSize) == this._buffers.length) {
                lastLen = -1;
            }
            return lastLen;
        }

        private int calculateEndIndex(long offset, long length) {
            int endIndex;
            int n = endIndex = length < 0L ? this._buffers.length - 1 : Math.toIntExact((length + offset) / (long)this.maxBufferSize);
            if (endIndex == this._buffers.length) {
                --endIndex;
            }
            return endIndex;
        }

        @Override
        public HttpField getContentLength() {
            return this._contentLength;
        }

        @Override
        public long getContentLengthValue() {
            return this._contentLengthValue;
        }
    }
}

