/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.metrics.expositionformats;

import io.prometheus.metrics.config.EscapingScheme;
import io.prometheus.metrics.expositionformats.ExpositionFormatWriter;
import io.prometheus.metrics.expositionformats.NameType;
import io.prometheus.metrics.expositionformats.TextFormatUtil;
import io.prometheus.metrics.model.snapshots.ClassicHistogramBuckets;
import io.prometheus.metrics.model.snapshots.CounterSnapshot;
import io.prometheus.metrics.model.snapshots.DataPointSnapshot;
import io.prometheus.metrics.model.snapshots.GaugeSnapshot;
import io.prometheus.metrics.model.snapshots.HistogramSnapshot;
import io.prometheus.metrics.model.snapshots.InfoSnapshot;
import io.prometheus.metrics.model.snapshots.Labels;
import io.prometheus.metrics.model.snapshots.MetricMetadata;
import io.prometheus.metrics.model.snapshots.MetricSnapshot;
import io.prometheus.metrics.model.snapshots.MetricSnapshots;
import io.prometheus.metrics.model.snapshots.PrometheusNaming;
import io.prometheus.metrics.model.snapshots.Quantile;
import io.prometheus.metrics.model.snapshots.SnapshotEscaper;
import io.prometheus.metrics.model.snapshots.StateSetSnapshot;
import io.prometheus.metrics.model.snapshots.SummarySnapshot;
import io.prometheus.metrics.model.snapshots.UnknownSnapshot;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import javax.annotation.Nullable;

public class PrometheusTextFormatWriter
implements ExpositionFormatWriter {
    public static final String CONTENT_TYPE = "text/plain; version=0.0.4; charset=utf-8";
    private final boolean writeCreatedTimestamps;
    private final boolean timestampsInMs;

    @Deprecated
    public PrometheusTextFormatWriter(boolean writeCreatedTimestamps) {
        this(writeCreatedTimestamps, false);
    }

    private PrometheusTextFormatWriter(boolean writeCreatedTimestamps, boolean timestampsInMs) {
        this.writeCreatedTimestamps = writeCreatedTimestamps;
        this.timestampsInMs = timestampsInMs;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static PrometheusTextFormatWriter create() {
        return PrometheusTextFormatWriter.builder().build();
    }

    @Override
    public boolean accepts(@Nullable String acceptHeader) {
        if (acceptHeader == null) {
            return false;
        }
        return acceptHeader.contains("text/plain");
    }

    @Override
    public String getContentType() {
        return CONTENT_TYPE;
    }

    @Override
    public void write(OutputStream out, MetricSnapshots metricSnapshots, EscapingScheme scheme) throws IOException {
        MetricSnapshot snapshot;
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(out, StandardCharsets.UTF_8));
        for (MetricSnapshot s : metricSnapshots) {
            snapshot = SnapshotEscaper.escapeMetricSnapshot(s, scheme);
            if (snapshot.getDataPoints().isEmpty()) continue;
            if (snapshot instanceof CounterSnapshot) {
                this.writeCounter(writer, (CounterSnapshot)snapshot, scheme);
                continue;
            }
            if (snapshot instanceof GaugeSnapshot) {
                this.writeGauge(writer, (GaugeSnapshot)snapshot, scheme);
                continue;
            }
            if (snapshot instanceof HistogramSnapshot) {
                this.writeHistogram(writer, (HistogramSnapshot)snapshot, scheme);
                continue;
            }
            if (snapshot instanceof SummarySnapshot) {
                this.writeSummary(writer, (SummarySnapshot)snapshot, scheme);
                continue;
            }
            if (snapshot instanceof InfoSnapshot) {
                this.writeInfo(writer, (InfoSnapshot)snapshot, scheme);
                continue;
            }
            if (snapshot instanceof StateSetSnapshot) {
                this.writeStateSet(writer, (StateSetSnapshot)snapshot, scheme);
                continue;
            }
            if (!(snapshot instanceof UnknownSnapshot)) continue;
            this.writeUnknown(writer, (UnknownSnapshot)snapshot, scheme);
        }
        if (this.writeCreatedTimestamps) {
            for (MetricSnapshot s : metricSnapshots) {
                snapshot = SnapshotEscaper.escapeMetricSnapshot(s, scheme);
                if (snapshot.getDataPoints().isEmpty()) continue;
                if (snapshot instanceof CounterSnapshot) {
                    this.writeCreated(writer, snapshot, scheme);
                    continue;
                }
                if (snapshot instanceof HistogramSnapshot) {
                    this.writeCreated(writer, snapshot, scheme);
                    continue;
                }
                if (!(snapshot instanceof SummarySnapshot)) continue;
                this.writeCreated(writer, snapshot, scheme);
            }
        }
        ((Writer)writer).flush();
    }

    public void writeCreated(Writer writer, MetricSnapshot snapshot, EscapingScheme scheme) throws IOException {
        boolean metadataWritten = false;
        MetricMetadata metadata = snapshot.getMetadata();
        for (DataPointSnapshot dataPointSnapshot : snapshot.getDataPoints()) {
            if (!dataPointSnapshot.hasCreatedTimestamp()) continue;
            if (!metadataWritten) {
                this.writeMetadata(writer, "_created", "gauge", metadata, scheme);
                metadataWritten = true;
            }
            this.writeNameAndLabels(writer, SnapshotEscaper.getMetadataName(metadata, scheme), "_created", dataPointSnapshot.getLabels(), scheme);
            TextFormatUtil.writePrometheusTimestamp(writer, dataPointSnapshot.getCreatedTimestampMillis(), this.timestampsInMs);
            this.writeScrapeTimestampAndNewline(writer, dataPointSnapshot);
        }
    }

    private void writeCounter(Writer writer, CounterSnapshot snapshot, EscapingScheme scheme) throws IOException {
        if (!snapshot.getDataPoints().isEmpty()) {
            MetricMetadata metadata = snapshot.getMetadata();
            this.writeMetadata(writer, "_total", "counter", metadata, scheme);
            for (CounterSnapshot.CounterDataPointSnapshot data : snapshot.getDataPoints()) {
                this.writeNameAndLabels(writer, SnapshotEscaper.getMetadataName(metadata, scheme), "_total", data.getLabels(), scheme);
                TextFormatUtil.writeDouble(writer, data.getValue());
                this.writeScrapeTimestampAndNewline(writer, data);
            }
        }
    }

    private void writeGauge(Writer writer, GaugeSnapshot snapshot, EscapingScheme scheme) throws IOException {
        MetricMetadata metadata = snapshot.getMetadata();
        this.writeMetadata(writer, "", "gauge", metadata, scheme);
        for (GaugeSnapshot.GaugeDataPointSnapshot data : snapshot.getDataPoints()) {
            this.writeNameAndLabels(writer, SnapshotEscaper.getMetadataName(metadata, scheme), null, data.getLabels(), scheme);
            TextFormatUtil.writeDouble(writer, data.getValue());
            this.writeScrapeTimestampAndNewline(writer, data);
        }
    }

    private void writeHistogram(Writer writer, HistogramSnapshot snapshot, EscapingScheme scheme) throws IOException {
        MetricMetadata metadata = snapshot.getMetadata();
        this.writeMetadata(writer, "", "histogram", metadata, scheme);
        for (HistogramSnapshot.HistogramDataPointSnapshot data : snapshot.getDataPoints()) {
            ClassicHistogramBuckets buckets = this.getClassicBuckets(data);
            long cumulativeCount = 0L;
            for (int i = 0; i < buckets.size(); ++i) {
                this.writeNameAndLabels(writer, SnapshotEscaper.getMetadataName(metadata, scheme), "_bucket", data.getLabels(), scheme, "le", buckets.getUpperBound(i));
                TextFormatUtil.writeLong(writer, cumulativeCount += buckets.getCount(i));
                this.writeScrapeTimestampAndNewline(writer, data);
            }
            if (snapshot.isGaugeHistogram()) continue;
            if (data.hasCount()) {
                this.writeNameAndLabels(writer, SnapshotEscaper.getMetadataName(metadata, scheme), "_count", data.getLabels(), scheme);
                TextFormatUtil.writeLong(writer, data.getCount());
                this.writeScrapeTimestampAndNewline(writer, data);
            }
            if (!data.hasSum()) continue;
            this.writeNameAndLabels(writer, SnapshotEscaper.getMetadataName(metadata, scheme), "_sum", data.getLabels(), scheme);
            TextFormatUtil.writeDouble(writer, data.getSum());
            this.writeScrapeTimestampAndNewline(writer, data);
        }
        if (snapshot.isGaugeHistogram()) {
            this.writeGaugeCountSum(writer, snapshot, metadata, scheme);
        }
    }

    private ClassicHistogramBuckets getClassicBuckets(HistogramSnapshot.HistogramDataPointSnapshot data) {
        if (data.getClassicBuckets().isEmpty()) {
            return ClassicHistogramBuckets.of(new double[]{Double.POSITIVE_INFINITY}, new long[]{data.getCount()});
        }
        return data.getClassicBuckets();
    }

    private void writeGaugeCountSum(Writer writer, HistogramSnapshot snapshot, MetricMetadata metadata, EscapingScheme scheme) throws IOException {
        boolean metadataWritten = false;
        for (HistogramSnapshot.HistogramDataPointSnapshot data : snapshot.getDataPoints()) {
            if (!data.hasCount()) continue;
            if (!metadataWritten) {
                this.writeMetadata(writer, "_gcount", "gauge", metadata, scheme);
                metadataWritten = true;
            }
            this.writeNameAndLabels(writer, SnapshotEscaper.getMetadataName(metadata, scheme), "_gcount", data.getLabels(), scheme);
            TextFormatUtil.writeLong(writer, data.getCount());
            this.writeScrapeTimestampAndNewline(writer, data);
        }
        metadataWritten = false;
        for (HistogramSnapshot.HistogramDataPointSnapshot data : snapshot.getDataPoints()) {
            if (!data.hasSum()) continue;
            if (!metadataWritten) {
                this.writeMetadata(writer, "_gsum", "gauge", metadata, scheme);
                metadataWritten = true;
            }
            this.writeNameAndLabels(writer, SnapshotEscaper.getMetadataName(metadata, scheme), "_gsum", data.getLabels(), scheme);
            TextFormatUtil.writeDouble(writer, data.getSum());
            this.writeScrapeTimestampAndNewline(writer, data);
        }
    }

    private void writeSummary(Writer writer, SummarySnapshot snapshot, EscapingScheme scheme) throws IOException {
        boolean metadataWritten = false;
        MetricMetadata metadata = snapshot.getMetadata();
        for (SummarySnapshot.SummaryDataPointSnapshot data : snapshot.getDataPoints()) {
            if (data.getQuantiles().size() == 0 && !data.hasCount() && !data.hasSum()) continue;
            if (!metadataWritten) {
                this.writeMetadata(writer, "", "summary", metadata, scheme);
                metadataWritten = true;
            }
            for (Quantile quantile : data.getQuantiles()) {
                this.writeNameAndLabels(writer, SnapshotEscaper.getMetadataName(metadata, scheme), null, data.getLabels(), scheme, "quantile", quantile.getQuantile());
                TextFormatUtil.writeDouble(writer, quantile.getValue());
                this.writeScrapeTimestampAndNewline(writer, data);
            }
            if (data.hasCount()) {
                this.writeNameAndLabels(writer, SnapshotEscaper.getMetadataName(metadata, scheme), "_count", data.getLabels(), scheme);
                TextFormatUtil.writeLong(writer, data.getCount());
                this.writeScrapeTimestampAndNewline(writer, data);
            }
            if (!data.hasSum()) continue;
            this.writeNameAndLabels(writer, SnapshotEscaper.getMetadataName(metadata, scheme), "_sum", data.getLabels(), scheme);
            TextFormatUtil.writeDouble(writer, data.getSum());
            this.writeScrapeTimestampAndNewline(writer, data);
        }
    }

    private void writeInfo(Writer writer, InfoSnapshot snapshot, EscapingScheme scheme) throws IOException {
        MetricMetadata metadata = snapshot.getMetadata();
        this.writeMetadata(writer, "_info", "gauge", metadata, scheme);
        for (InfoSnapshot.InfoDataPointSnapshot data : snapshot.getDataPoints()) {
            this.writeNameAndLabels(writer, SnapshotEscaper.getMetadataName(metadata, scheme), "_info", data.getLabels(), scheme);
            writer.write("1");
            this.writeScrapeTimestampAndNewline(writer, data);
        }
    }

    private void writeStateSet(Writer writer, StateSetSnapshot snapshot, EscapingScheme scheme) throws IOException {
        MetricMetadata metadata = snapshot.getMetadata();
        this.writeMetadata(writer, "", "gauge", metadata, scheme);
        for (StateSetSnapshot.StateSetDataPointSnapshot data : snapshot.getDataPoints()) {
            for (int i = 0; i < data.size(); ++i) {
                writer.write(SnapshotEscaper.getMetadataName(metadata, scheme));
                writer.write(123);
                for (int j = 0; j < data.getLabels().size(); ++j) {
                    if (j > 0) {
                        writer.write(",");
                    }
                    writer.write(SnapshotEscaper.getSnapshotLabelName(data.getLabels(), j, scheme));
                    writer.write("=\"");
                    TextFormatUtil.writeEscapedString(writer, data.getLabels().getValue(j));
                    writer.write("\"");
                }
                if (!data.getLabels().isEmpty()) {
                    writer.write(",");
                }
                writer.write(SnapshotEscaper.getMetadataName(metadata, scheme));
                writer.write("=\"");
                TextFormatUtil.writeEscapedString(writer, data.getName(i));
                writer.write("\"} ");
                if (data.isTrue(i)) {
                    writer.write("1");
                } else {
                    writer.write("0");
                }
                this.writeScrapeTimestampAndNewline(writer, data);
            }
        }
    }

    private void writeUnknown(Writer writer, UnknownSnapshot snapshot, EscapingScheme scheme) throws IOException {
        MetricMetadata metadata = snapshot.getMetadata();
        this.writeMetadata(writer, "", "untyped", metadata, scheme);
        for (UnknownSnapshot.UnknownDataPointSnapshot data : snapshot.getDataPoints()) {
            this.writeNameAndLabels(writer, SnapshotEscaper.getMetadataName(metadata, scheme), null, data.getLabels(), scheme);
            TextFormatUtil.writeDouble(writer, data.getValue());
            this.writeScrapeTimestampAndNewline(writer, data);
        }
    }

    private void writeNameAndLabels(Writer writer, String name, @Nullable String suffix, Labels labels, EscapingScheme escapingScheme) throws IOException {
        this.writeNameAndLabels(writer, name, suffix, labels, escapingScheme, null, 0.0);
    }

    private void writeNameAndLabels(Writer writer, String name, @Nullable String suffix, Labels labels, EscapingScheme scheme, @Nullable String additionalLabelName, double additionalLabelValue) throws IOException {
        boolean metricInsideBraces = false;
        if (!PrometheusNaming.isValidLegacyMetricName(name)) {
            metricInsideBraces = true;
            writer.write(123);
        }
        TextFormatUtil.writeName(writer, name + (suffix != null ? suffix : ""), NameType.Metric);
        if (!labels.isEmpty() || additionalLabelName != null) {
            TextFormatUtil.writeLabels(writer, labels, additionalLabelName, additionalLabelValue, metricInsideBraces, scheme);
        } else if (metricInsideBraces) {
            writer.write(125);
        }
        writer.write(32);
    }

    private void writeMetadata(Writer writer, @Nullable String suffix, String typeString, MetricMetadata metadata, EscapingScheme scheme) throws IOException {
        String name = SnapshotEscaper.getMetadataName(metadata, scheme) + (suffix != null ? suffix : "");
        if (metadata.getHelp() != null && !metadata.getHelp().isEmpty()) {
            writer.write("# HELP ");
            TextFormatUtil.writeName(writer, name, NameType.Metric);
            writer.write(32);
            this.writeEscapedHelp(writer, metadata.getHelp());
            writer.write(10);
        }
        writer.write("# TYPE ");
        TextFormatUtil.writeName(writer, name, NameType.Metric);
        writer.write(32);
        writer.write(typeString);
        writer.write(10);
    }

    private void writeEscapedHelp(Writer writer, String s) throws IOException {
        block4: for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '\\': {
                    writer.append("\\\\");
                    continue block4;
                }
                case '\n': {
                    writer.append("\\n");
                    continue block4;
                }
                default: {
                    writer.append(c);
                }
            }
        }
    }

    private void writeScrapeTimestampAndNewline(Writer writer, DataPointSnapshot data) throws IOException {
        if (data.hasScrapeTimestamp()) {
            writer.write(32);
            TextFormatUtil.writePrometheusTimestamp(writer, data.getScrapeTimestampMillis(), this.timestampsInMs);
        }
        writer.write(10);
    }

    public static class Builder {
        boolean includeCreatedTimestamps;
        boolean timestampsInMs = true;

        private Builder() {
        }

        public Builder setIncludeCreatedTimestamps(boolean includeCreatedTimestamps) {
            this.includeCreatedTimestamps = includeCreatedTimestamps;
            return this;
        }

        @Deprecated
        public Builder setTimestampsInMs(boolean timestampsInMs) {
            this.timestampsInMs = timestampsInMs;
            return this;
        }

        public PrometheusTextFormatWriter build() {
            return new PrometheusTextFormatWriter(this.includeCreatedTimestamps, this.timestampsInMs);
        }
    }
}

