/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.processor;

import com.google.common.collect.ImmutableList;
import jakarta.inject.Inject;
import java.util.Collections;
import java.util.List;
import org.apache.james.imap.api.ImapConstants;
import org.apache.james.imap.api.message.Capability;
import org.apache.james.imap.api.message.response.ImapResponseMessage;
import org.apache.james.imap.api.message.response.StatusResponseFactory;
import org.apache.james.imap.api.process.ImapSession;
import org.apache.james.imap.api.process.MailboxType;
import org.apache.james.imap.api.process.MailboxTyper;
import org.apache.james.imap.main.PathConverter;
import org.apache.james.imap.message.request.ListRequest;
import org.apache.james.imap.message.request.XListRequest;
import org.apache.james.imap.message.response.XListResponse;
import org.apache.james.imap.processor.CapabilityImplementingProcessor;
import org.apache.james.imap.processor.ListProcessor;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.SubscriptionManager;
import org.apache.james.mailbox.model.MailboxMetaData;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.metrics.api.MetricFactory;

public class XListProcessor
extends ListProcessor<XListRequest>
implements CapabilityImplementingProcessor {
    private static final List<Capability> XLIST_CAPS = ImmutableList.of((Object)ImapConstants.SUPPORTS_XLIST);

    @Inject
    public XListProcessor(MailboxManager mailboxManager, StatusResponseFactory factory, MetricFactory metricFactory, SubscriptionManager subscriptionManager, PathConverter.Factory pathConverterFactory) {
        this(mailboxManager, factory, null, metricFactory, subscriptionManager, pathConverterFactory);
    }

    public XListProcessor(MailboxManager mailboxManager, StatusResponseFactory factory, MailboxTyper mailboxTyper, MetricFactory metricFactory, SubscriptionManager subscriptionManager, PathConverter.Factory pathConverterFactory) {
        super(XListRequest.class, mailboxManager, factory, metricFactory, subscriptionManager, null, mailboxTyper, pathConverterFactory);
    }

    @Override
    public List<Capability> getImplementedCapabilities(ImapSession session) {
        if (this.mailboxTyper == null) {
            return Collections.emptyList();
        }
        return XLIST_CAPS;
    }

    @Override
    protected ImapResponseMessage createResponse(MailboxMetaData.Children children, MailboxMetaData.Selectability selectability, String name, char hierarchyDelimiter, MailboxType type, boolean isSubscribed) {
        return new XListResponse(children, selectability, name, hierarchyDelimiter, type);
    }

    @Override
    protected MailboxType getMailboxType(ListRequest request, ImapSession session, MailboxPath path) {
        return this.mailboxTyper.getMailboxType(session, path);
    }
}

