/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.session;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.context.DriverContext;
import com.datastax.oss.driver.api.core.metadata.Metadata;
import com.datastax.oss.driver.api.core.metrics.Metrics;
import com.datastax.oss.driver.api.core.session.Request;
import com.datastax.oss.driver.api.core.session.Session;
import com.datastax.oss.driver.api.core.type.reflect.GenericType;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Optional;
import java.util.concurrent.CompletionStage;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class SessionWrapper
implements Session {
    private final Session delegate;

    public SessionWrapper(@NonNull Session delegate) {
        this.delegate = delegate;
    }

    @NonNull
    public Session getDelegate() {
        return this.delegate;
    }

    @Override
    @NonNull
    public String getName() {
        return this.delegate.getName();
    }

    @Override
    @NonNull
    public Metadata getMetadata() {
        return this.delegate.getMetadata();
    }

    @Override
    public boolean isSchemaMetadataEnabled() {
        return this.delegate.isSchemaMetadataEnabled();
    }

    @Override
    @NonNull
    public CompletionStage<Metadata> setSchemaMetadataEnabled(@Nullable Boolean newValue) {
        return this.delegate.setSchemaMetadataEnabled(newValue);
    }

    @Override
    @NonNull
    public CompletionStage<Metadata> refreshSchemaAsync() {
        return this.delegate.refreshSchemaAsync();
    }

    @Override
    @NonNull
    public CompletionStage<Boolean> checkSchemaAgreementAsync() {
        return this.delegate.checkSchemaAgreementAsync();
    }

    @Override
    @NonNull
    public DriverContext getContext() {
        return this.delegate.getContext();
    }

    @Override
    @NonNull
    public Optional<CqlIdentifier> getKeyspace() {
        return this.delegate.getKeyspace();
    }

    @Override
    @NonNull
    public Optional<Metrics> getMetrics() {
        return this.delegate.getMetrics();
    }

    @Override
    @Nullable
    public <RequestT extends Request, ResultT> ResultT execute(@NonNull RequestT request, @NonNull GenericType<ResultT> resultType) {
        return this.delegate.execute(request, resultType);
    }

    @Override
    @NonNull
    public CompletionStage<Void> closeFuture() {
        return this.delegate.closeFuture();
    }

    @Override
    @NonNull
    public CompletionStage<Void> closeAsync() {
        return this.delegate.closeAsync();
    }

    @Override
    @NonNull
    public CompletionStage<Void> forceCloseAsync() {
        return this.delegate.forceCloseAsync();
    }
}

