/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.api.core.auth;

import com.datastax.dse.driver.api.core.auth.BaseDseAuthenticator;
import com.datastax.oss.driver.api.core.auth.AuthProvider;
import com.datastax.oss.driver.api.core.auth.AuthenticationException;
import com.datastax.oss.driver.api.core.auth.Authenticator;
import com.datastax.oss.driver.api.core.metadata.EndPoint;
import com.datastax.oss.driver.shaded.guava.common.base.Charsets;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Objects;
import net.jcip.annotations.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public abstract class PlainTextAuthProviderBase
implements AuthProvider {
    private static final Logger LOG = LoggerFactory.getLogger(PlainTextAuthProviderBase.class);
    private final String logPrefix;

    protected PlainTextAuthProviderBase(@NonNull String logPrefix) {
        this.logPrefix = Objects.requireNonNull(logPrefix);
    }

    @NonNull
    protected abstract Credentials getCredentials(@NonNull EndPoint var1, @NonNull String var2);

    @Override
    @NonNull
    public Authenticator newAuthenticator(@NonNull EndPoint endPoint, @NonNull String serverAuthenticator) throws AuthenticationException {
        return new PlainTextAuthenticator(this.getCredentials(endPoint, serverAuthenticator), endPoint, serverAuthenticator);
    }

    @Override
    public void onMissingChallenge(@NonNull EndPoint endPoint) {
        LOG.warn("[{}] {} did not send an authentication challenge; This is suspicious because the driver expects authentication", (Object)this.logPrefix, (Object)endPoint);
    }

    @Override
    public void close() {
    }

    protected static class PlainTextAuthenticator
    extends BaseDseAuthenticator {
        private static final ByteBuffer MECHANISM = ByteBuffer.wrap("PLAIN".getBytes(StandardCharsets.UTF_8)).asReadOnlyBuffer();
        private static final ByteBuffer SERVER_INITIAL_CHALLENGE = ByteBuffer.wrap("PLAIN-START".getBytes(StandardCharsets.UTF_8)).asReadOnlyBuffer();
        private static final EndPoint DUMMY_END_POINT = new EndPoint(){

            @Override
            @NonNull
            public SocketAddress resolve() {
                return new InetSocketAddress("127.0.0.1", 9042);
            }

            @Override
            @NonNull
            public String asMetricPrefix() {
                return "";
            }
        };
        private final ByteBuffer encodedCredentials;
        private final EndPoint endPoint;

        protected PlainTextAuthenticator(@NonNull Credentials credentials, @NonNull EndPoint endPoint, @NonNull String serverAuthenticator) {
            super(serverAuthenticator);
            Objects.requireNonNull(credentials);
            Objects.requireNonNull(endPoint);
            ByteBuffer authorizationId = PlainTextAuthenticator.toUtf8Bytes(credentials.getAuthorizationId());
            ByteBuffer username = PlainTextAuthenticator.toUtf8Bytes(credentials.getUsername());
            ByteBuffer password = PlainTextAuthenticator.toUtf8Bytes(credentials.getPassword());
            this.encodedCredentials = ByteBuffer.allocate(authorizationId.remaining() + username.remaining() + password.remaining() + 2);
            this.encodedCredentials.put(authorizationId);
            this.encodedCredentials.put((byte)0);
            this.encodedCredentials.put(username);
            this.encodedCredentials.put((byte)0);
            this.encodedCredentials.put(password);
            this.encodedCredentials.flip();
            PlainTextAuthenticator.clear(authorizationId);
            PlainTextAuthenticator.clear(username);
            PlainTextAuthenticator.clear(password);
            this.endPoint = endPoint;
        }

        @Deprecated
        protected PlainTextAuthenticator(@NonNull Credentials credentials) {
            this(credentials, DUMMY_END_POINT, "org.apache.cassandra.auth.PasswordAuthenticator");
        }

        private static ByteBuffer toUtf8Bytes(char[] charArray) {
            CharBuffer charBuffer = CharBuffer.wrap(charArray);
            return Charsets.UTF_8.encode(charBuffer);
        }

        private static void clear(ByteBuffer buffer) {
            buffer.rewind();
            while (buffer.remaining() > 0) {
                buffer.put((byte)0);
            }
        }

        @Override
        @NonNull
        public ByteBuffer getMechanism() {
            return MECHANISM;
        }

        @Override
        @NonNull
        public ByteBuffer getInitialServerChallenge() {
            return SERVER_INITIAL_CHALLENGE;
        }

        @Override
        @Nullable
        public ByteBuffer evaluateChallengeSync(@Nullable ByteBuffer challenge) {
            if (SERVER_INITIAL_CHALLENGE.equals(challenge)) {
                return this.encodedCredentials;
            }
            throw new AuthenticationException(this.endPoint, "Incorrect challenge from server");
        }
    }

    public static class Credentials {
        private final char[] username;
        private final char[] password;
        private final char[] authorizationId;

        public Credentials(@NonNull char[] username, @NonNull char[] password, @NonNull char[] authorizationId) {
            this.username = Objects.requireNonNull(username);
            this.password = Objects.requireNonNull(password);
            this.authorizationId = Objects.requireNonNull(authorizationId);
        }

        public Credentials(@NonNull char[] username, @NonNull char[] password) {
            this(username, password, new char[0]);
        }

        @NonNull
        public char[] getUsername() {
            return this.username;
        }

        @Deprecated
        @NonNull
        public char[] getAuthenticationId() {
            return this.username;
        }

        @NonNull
        public char[] getPassword() {
            return this.password;
        }

        @NonNull
        public char[] getAuthorizationId() {
            return this.authorizationId;
        }

        protected void clear() {
            Arrays.fill(this.getUsername(), '\u0000');
            Arrays.fill(this.getPassword(), '\u0000');
            Arrays.fill(this.getAuthorizationId(), '\u0000');
        }
    }
}

