/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.queue.rabbitmq.view;

import java.util.Objects;
import java.util.Optional;
import org.apache.commons.configuration2.Configuration;

public class RabbitMQMailQueueConfiguration {
    private static final boolean DEFAULT_SIZE_METRICS_DISABLED = false;
    public static final String SIZE_METRICS_ENABLED_PROPERTY = "mailqueue.size.metricsEnabled";
    private static final String MAIL_QUEUE_PUBLISH_CONFIRM_ENABLED = "mailqueue.publish.confirm.enabled";
    private final boolean sizeMetricsEnabled;
    private final boolean mailQueuePublishConfirmEnabled;

    public static Builder builder() {
        return new Builder();
    }

    public static RabbitMQMailQueueConfiguration from(Configuration configuration) {
        return RabbitMQMailQueueConfiguration.builder().sizeMetricsEnabled(Optional.ofNullable(configuration.getBoolean(SIZE_METRICS_ENABLED_PROPERTY, null))).mailQueuePublishConfirmEnabled(configuration.getBoolean(MAIL_QUEUE_PUBLISH_CONFIRM_ENABLED, null)).build();
    }

    public static RabbitMQMailQueueConfiguration sizeMetricsEnabled() {
        return RabbitMQMailQueueConfiguration.builder().sizeMetricsEnabled(true).build();
    }

    public static RabbitMQMailQueueConfiguration sizeMetricsDisabled() {
        return RabbitMQMailQueueConfiguration.builder().sizeMetricsEnabled(false).build();
    }

    private RabbitMQMailQueueConfiguration(boolean sizeMetricsEnabled, boolean mailQueuePublishConfirmEnabled) {
        this.sizeMetricsEnabled = sizeMetricsEnabled;
        this.mailQueuePublishConfirmEnabled = mailQueuePublishConfirmEnabled;
    }

    public boolean isMailQueuePublishConfirmEnabled() {
        return this.mailQueuePublishConfirmEnabled;
    }

    public boolean isSizeMetricsEnabled() {
        return this.sizeMetricsEnabled;
    }

    public final boolean equals(Object o) {
        if (o instanceof RabbitMQMailQueueConfiguration) {
            RabbitMQMailQueueConfiguration that = (RabbitMQMailQueueConfiguration)o;
            return Objects.equals(this.sizeMetricsEnabled, that.sizeMetricsEnabled) && Objects.equals(this.mailQueuePublishConfirmEnabled, that.mailQueuePublishConfirmEnabled);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hash(this.sizeMetricsEnabled, this.mailQueuePublishConfirmEnabled);
    }

    public static class Builder {
        private Optional<Boolean> sizeMetricsEnabled = Optional.empty();
        private Optional<Boolean> mailQueuePublishConfirmEnabled = Optional.empty();

        public Builder sizeMetricsEnabled(boolean sizeMetricsEnabled) {
            this.sizeMetricsEnabled = Optional.of(sizeMetricsEnabled);
            return this;
        }

        public Builder sizeMetricsEnabled(Optional<Boolean> sizeMetricsEnabled) {
            this.sizeMetricsEnabled = sizeMetricsEnabled;
            return this;
        }

        public Builder mailQueuePublishConfirmEnabled(Boolean mailQueuePublishConfirmEnabled) {
            this.mailQueuePublishConfirmEnabled = Optional.ofNullable(mailQueuePublishConfirmEnabled);
            return this;
        }

        public RabbitMQMailQueueConfiguration build() {
            return new RabbitMQMailQueueConfiguration(this.sizeMetricsEnabled.orElse(false), this.mailQueuePublishConfirmEnabled.orElse(true));
        }
    }
}

