/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.user.postgres;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.Collection;
import java.util.Iterator;
import java.util.Optional;
import org.apache.james.backends.postgres.utils.PostgresExecutor;
import org.apache.james.core.Username;
import org.apache.james.user.api.AlreadyExistInUsersRepositoryException;
import org.apache.james.user.api.UsersRepositoryException;
import org.apache.james.user.api.model.User;
import org.apache.james.user.lib.UsersDAO;
import org.apache.james.user.lib.model.Algorithm;
import org.apache.james.user.lib.model.DefaultUser;
import org.apache.james.user.postgres.PostgresUserDataDefinition;
import org.apache.james.user.postgres.PostgresUsersRepositoryConfiguration;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.Record;
import org.jooq.SelectField;
import org.jooq.SelectFieldOrAsterisk;
import org.jooq.UpdateConditionStep;
import org.jooq.impl.DSL;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class PostgresUsersDAO
implements UsersDAO {
    private final PostgresExecutor postgresExecutor;
    private final Algorithm algorithm;
    private final Algorithm.HashingMode fallbackHashingMode;

    @Inject
    public PostgresUsersDAO(@Named(value="default") PostgresExecutor postgresExecutor, PostgresUsersRepositoryConfiguration postgresUsersRepositoryConfiguration) {
        this.postgresExecutor = postgresExecutor;
        this.algorithm = postgresUsersRepositoryConfiguration.getPreferredAlgorithm();
        this.fallbackHashingMode = postgresUsersRepositoryConfiguration.getFallbackHashingMode();
    }

    public Optional<? extends User> getUserByName(Username name) {
        return this.getUserByNameReactive(name).blockOptional();
    }

    private Mono<DefaultUser> getUserByNameReactive(Username name) {
        return this.postgresExecutor.executeRow(dsl -> Mono.from((Publisher)dsl.selectFrom(PostgresUserDataDefinition.PostgresUserTable.TABLE_NAME).where(PostgresUserDataDefinition.PostgresUserTable.USERNAME.eq((Object)name.asString())))).map(record -> new DefaultUser(name, (String)record.get(PostgresUserDataDefinition.PostgresUserTable.HASHED_PASSWORD), Algorithm.of((String)((String)record.get(PostgresUserDataDefinition.PostgresUserTable.ALGORITHM)), (Algorithm.HashingMode)this.fallbackHashingMode), this.algorithm));
    }

    public void updateUser(User user) throws UsersRepositoryException {
        Preconditions.checkArgument((boolean)(user instanceof DefaultUser));
        DefaultUser defaultUser = (DefaultUser)user;
        boolean executed = this.postgresExecutor.executeRow(dslContext -> Mono.from((Publisher)dslContext.update(PostgresUserDataDefinition.PostgresUserTable.TABLE_NAME).set(PostgresUserDataDefinition.PostgresUserTable.HASHED_PASSWORD, (Object)defaultUser.getHashedPassword()).set(PostgresUserDataDefinition.PostgresUserTable.ALGORITHM, (Object)defaultUser.getHashAlgorithm().asString()).where(PostgresUserDataDefinition.PostgresUserTable.USERNAME.eq((Object)user.getUserName().asString())).returning(new SelectFieldOrAsterisk[]{PostgresUserDataDefinition.PostgresUserTable.USERNAME}))).map(record -> (String)record.get(PostgresUserDataDefinition.PostgresUserTable.USERNAME)).blockOptional().isPresent();
        if (!executed) {
            throw new UsersRepositoryException("Unable to update user");
        }
    }

    public void removeUser(Username name) throws UsersRepositoryException {
        boolean executed = this.postgresExecutor.executeRow(dslContext -> Mono.from((Publisher)dslContext.deleteFrom(PostgresUserDataDefinition.PostgresUserTable.TABLE_NAME).where(PostgresUserDataDefinition.PostgresUserTable.USERNAME.eq((Object)name.asString())).returning(new SelectFieldOrAsterisk[]{PostgresUserDataDefinition.PostgresUserTable.USERNAME}))).map(record -> (String)record.get(PostgresUserDataDefinition.PostgresUserTable.USERNAME)).blockOptional().isPresent();
        if (!executed) {
            throw new UsersRepositoryException("Unable to update user");
        }
    }

    public boolean contains(Username name) {
        return (Boolean)this.containsReactive(name).block();
    }

    public Mono<Boolean> containsReactive(Username name) {
        return this.postgresExecutor.executeExists(dsl -> dsl.selectOne().from(PostgresUserDataDefinition.PostgresUserTable.TABLE_NAME).where(PostgresUserDataDefinition.PostgresUserTable.USERNAME.eq((Object)name.asString())));
    }

    public int countUsers() {
        return (Integer)this.postgresExecutor.executeRow(dsl -> Mono.from((Publisher)dsl.select((SelectField)DSL.count()).from(PostgresUserDataDefinition.PostgresUserTable.TABLE_NAME))).map(record -> (Integer)record.get(0, Integer.class)).block();
    }

    public Iterator<Username> list() throws UsersRepositoryException {
        return this.listReactive().toIterable().iterator();
    }

    public Flux<Username> listReactive() {
        return this.postgresExecutor.executeRows(dslContext -> Flux.from((Publisher)dslContext.select(PostgresUserDataDefinition.PostgresUserTable.USERNAME).from(PostgresUserDataDefinition.PostgresUserTable.TABLE_NAME)), true).map(record -> Username.of((String)((String)record.get(PostgresUserDataDefinition.PostgresUserTable.USERNAME))));
    }

    public void addUser(Username username, String password) {
        DefaultUser user = new DefaultUser(username, this.algorithm, this.algorithm);
        user.setPassword(password);
        this.postgresExecutor.executeRow(dslContext -> Mono.from((Publisher)dslContext.insertInto(PostgresUserDataDefinition.PostgresUserTable.TABLE_NAME, PostgresUserDataDefinition.PostgresUserTable.USERNAME, PostgresUserDataDefinition.PostgresUserTable.HASHED_PASSWORD, PostgresUserDataDefinition.PostgresUserTable.ALGORITHM).values((Object)user.getUserName().asString(), (Object)user.getHashedPassword(), (Object)user.getHashAlgorithm().asString()).onConflictOnConstraint(PostgresUserDataDefinition.PostgresUserTable.USERNAME_PRIMARY_KEY).doNothing().returning(new SelectFieldOrAsterisk[]{PostgresUserDataDefinition.PostgresUserTable.USERNAME}))).switchIfEmpty(Mono.error((Throwable)new AlreadyExistInUsersRepositoryException("User with username " + String.valueOf(username) + " already exist!"))).block();
    }

    public Mono<Void> addAuthorizedUser(Username baseUser, Username userWithAccess, boolean targetUserExists) {
        return this.addUserToList(PostgresUserDataDefinition.PostgresUserTable.AUTHORIZED_USERS, baseUser, userWithAccess).then(this.addDelegatedUser(baseUser, userWithAccess, targetUserExists));
    }

    private Mono<Void> addDelegatedUser(Username baseUser, Username userWithAccess, boolean targetUserExists) {
        if (targetUserExists) {
            return this.addUserToList(PostgresUserDataDefinition.PostgresUserTable.DELEGATED_USERS, userWithAccess, baseUser);
        }
        return Mono.empty();
    }

    private Mono<Void> addUserToList(Field<String[]> field, Username baseUser, Username targetUser) {
        String fullAuthorizedUsersColumnName = PostgresUserDataDefinition.PostgresUserTable.TABLE.getName() + "." + field.getName();
        return this.postgresExecutor.executeVoid(dslContext -> Mono.from((Publisher)dslContext.insertInto(PostgresUserDataDefinition.PostgresUserTable.TABLE_NAME).set(PostgresUserDataDefinition.PostgresUserTable.USERNAME, (Object)baseUser.asString()).set(field, DSL.array((Object[])new String[]{targetUser.asString()})).onConflict(new Field[]{PostgresUserDataDefinition.PostgresUserTable.USERNAME}).doUpdate().set(DSL.field((String)field.getName()), (Object)DSL.field((String)("array_append(coalesce(" + fullAuthorizedUsersColumnName + ", array[]::varchar[]), ?)"), (Object[])new Object[]{targetUser.asString()})).where(DSL.field((String)fullAuthorizedUsersColumnName).isNull().or(DSL.field((String)fullAuthorizedUsersColumnName).notContains((Object)new String[]{targetUser.asString()})))));
    }

    public Mono<Void> removeAuthorizedUser(Username baseUser, Username userWithAccess) {
        return this.removeUserInAuthorizedList(baseUser, userWithAccess).then(this.removeUserInDelegatedList(userWithAccess, baseUser));
    }

    public Mono<Void> removeDelegatedToUser(Username baseUser, Username delegatedToUser) {
        return this.removeUserInDelegatedList(baseUser, delegatedToUser).then(this.removeUserInAuthorizedList(delegatedToUser, baseUser));
    }

    private Mono<Void> removeUserInAuthorizedList(Username baseUser, Username targetUser) {
        return this.removeUserFromList(PostgresUserDataDefinition.PostgresUserTable.AUTHORIZED_USERS, baseUser, targetUser);
    }

    private Mono<Void> removeUserInDelegatedList(Username baseUser, Username targetUser) {
        return this.removeUserFromList(PostgresUserDataDefinition.PostgresUserTable.DELEGATED_USERS, baseUser, targetUser);
    }

    private Mono<Void> removeUserFromList(Field<String[]> field, Username baseUser, Username targetUser) {
        return this.postgresExecutor.executeVoid(dslContext -> Mono.from(this.createQueryRemoveUserFromList((DSLContext)dslContext, field, baseUser, targetUser)));
    }

    private UpdateConditionStep<Record> createQueryRemoveUserFromList(DSLContext dslContext, Field<String[]> field, Username baseUser, Username targetUser) {
        return dslContext.update(PostgresUserDataDefinition.PostgresUserTable.TABLE_NAME).set(DSL.field((String)field.getName()), (Object)DSL.field((String)("array_remove(" + field.getName() + ", ?)"), (Object[])new Object[]{targetUser.asString()})).where(PostgresUserDataDefinition.PostgresUserTable.USERNAME.eq((Object)baseUser.asString())).and(DSL.field((String)field.getName()).isNotNull());
    }

    public Mono<Void> removeAllAuthorizedUsers(Username baseUser) {
        return this.getAuthorizedUsers(baseUser).collect(ImmutableList.toImmutableList()).flatMap(usernames -> this.postgresExecutor.executeVoid(dslContext -> Mono.from((Publisher)dslContext.batch((Collection)usernames.stream().map(username -> this.createQueryRemoveUserFromList((DSLContext)dslContext, PostgresUserDataDefinition.PostgresUserTable.DELEGATED_USERS, (Username)username, baseUser)).collect(ImmutableList.toImmutableList()))))).then(this.postgresExecutor.executeVoid(dslContext -> Mono.from((Publisher)dslContext.update(PostgresUserDataDefinition.PostgresUserTable.TABLE_NAME).setNull(PostgresUserDataDefinition.PostgresUserTable.AUTHORIZED_USERS).where(PostgresUserDataDefinition.PostgresUserTable.USERNAME.eq((Object)baseUser.asString())))));
    }

    public Flux<Username> getAuthorizedUsers(Username name) {
        return this.getUsersFromList(PostgresUserDataDefinition.PostgresUserTable.AUTHORIZED_USERS, name);
    }

    public Flux<Username> getDelegatedToUsers(Username name) {
        return this.getUsersFromList(PostgresUserDataDefinition.PostgresUserTable.DELEGATED_USERS, name);
    }

    public Flux<Username> getUsersFromList(Field<String[]> field, Username name) {
        return this.postgresExecutor.executeRow(dslContext -> Mono.from((Publisher)dslContext.select((SelectField)field).from(PostgresUserDataDefinition.PostgresUserTable.TABLE_NAME).where(PostgresUserDataDefinition.PostgresUserTable.USERNAME.eq((Object)name.asString())))).flatMapMany(record -> (Publisher)Optional.ofNullable((String[])record.get(field)).map(Flux::fromArray).orElse(Flux.empty())).map(Username::of);
    }
}

