/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.rrt.lib;

import jakarta.inject.Inject;
import org.apache.james.core.Domain;
import org.apache.james.core.MailAddress;
import org.apache.james.core.Username;
import org.apache.james.rrt.api.AliasReverseResolver;
import org.apache.james.rrt.api.CanSendFrom;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class CanSendFromImpl
implements CanSendFrom {
    private static final Logger LOGGER = LoggerFactory.getLogger(CanSendFromImpl.class);
    private final AliasReverseResolver aliasReverseResolver;

    @Inject
    public CanSendFromImpl(AliasReverseResolver aliasReverseResolver) {
        this.aliasReverseResolver = aliasReverseResolver;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean userCanSendFrom(Username connectedUser, Username fromUser) {
        try {
            if (connectedUser.equals((Object)fromUser)) return true;
            if ((Boolean)this.allValidFromAddressesForUser(connectedUser).map(Username::fromMailAddress).any(arg_0 -> ((Username)fromUser).equals(arg_0)).block() == false) return false;
            return true;
        }
        catch (Exception e) {
            LOGGER.warn("Error upon {} mapping resolution for {}. You might want to audit mapping content for this mapping entry. ", (Object)fromUser.asString(), (Object)connectedUser.asString());
            return false;
        }
    }

    public Publisher<Boolean> userCanSendFromReactive(Username connectedUser, Username fromUser) {
        if (connectedUser.equals((Object)fromUser)) {
            return Mono.just((Object)true);
        }
        return this.allValidFromAddressesForUser(connectedUser).map(Username::fromMailAddress).any(arg_0 -> ((Username)fromUser).equals(arg_0));
    }

    public Flux<MailAddress> allValidFromAddressesForUser(Username user) {
        return Flux.from((Publisher)this.aliasReverseResolver.listAddresses(user));
    }

    @FunctionalInterface
    static interface DomainFetcher {
        public Flux<Domain> fetch(Domain var1);
    }
}

