/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.protocols.smtp.core;

import org.apache.james.protocols.api.ProtocolSession;
import org.apache.james.protocols.api.Response;
import org.apache.james.protocols.api.handler.LineHandler;
import org.apache.james.protocols.smtp.SMTPSession;
import org.apache.james.protocols.smtp.core.DataLineFilter;

public abstract class SeparatingDataLineFilter
implements DataLineFilter {
    @Override
    public final Response onLine(SMTPSession session, byte[] line, LineHandler<SMTPSession> next) {
        if (!session.headerComplete()) {
            if (line.length == 2 && line[0] == 13 && line[1] == 10) {
                Response response = this.onSeparatorLine(session, line, next);
                session.setHeaderComplete(true);
                return response;
            }
            return this.onHeadersLine(session, line, next);
        }
        return this.onBodyLine(session, line, next);
    }

    protected Response onSeparatorLine(SMTPSession session, byte[] line, LineHandler<SMTPSession> next) {
        return next.onLine((ProtocolSession)session, line);
    }

    protected Response onHeadersLine(SMTPSession session, byte[] line, LineHandler<SMTPSession> next) {
        return next.onLine((ProtocolSession)session, line);
    }

    protected Response onBodyLine(SMTPSession session, byte[] line, LineHandler<SMTPSession> next) {
        return next.onLine((ProtocolSession)session, line);
    }
}

