/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.query_dsl;

import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.Script;
import org.opensearch.client.opensearch._types.query_dsl.Query;
import org.opensearch.client.opensearch._types.query_dsl.QueryBase;
import org.opensearch.client.opensearch._types.query_dsl.QueryVariant;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;

@JsonpDeserializable
public class ScriptScoreQuery
extends QueryBase
implements QueryVariant {
    @Nullable
    private final Float minScore;
    private final Query query;
    private final Script script;
    public static final JsonpDeserializer<ScriptScoreQuery> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ScriptScoreQuery::setupScriptScoreQueryDeserializer);

    private ScriptScoreQuery(Builder builder) {
        super(builder);
        this.minScore = builder.minScore;
        this.query = ApiTypeHelper.requireNonNull(builder.query, this, "query");
        this.script = ApiTypeHelper.requireNonNull(builder.script, this, "script");
    }

    public static ScriptScoreQuery of(Function<Builder, ObjectBuilder<ScriptScoreQuery>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Query.Kind _queryKind() {
        return Query.Kind.ScriptScore;
    }

    @Nullable
    public final Float minScore() {
        return this.minScore;
    }

    public final Query query() {
        return this.query;
    }

    public final Script script() {
        return this.script;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (this.minScore != null) {
            generator.writeKey("min_score");
            generator.write((double)this.minScore.floatValue());
        }
        generator.writeKey("query");
        this.query.serialize(generator, mapper);
        generator.writeKey("script");
        this.script.serialize(generator, mapper);
    }

    protected static void setupScriptScoreQueryDeserializer(ObjectDeserializer<Builder> op) {
        QueryBase.setupQueryBaseDeserializer(op);
        op.add(Builder::minScore, JsonpDeserializer.floatDeserializer(), "min_score");
        op.add(Builder::query, Query._DESERIALIZER, "query");
        op.add(Builder::script, Script._DESERIALIZER, "script");
    }

    public static class Builder
    extends QueryBase.AbstractBuilder<Builder>
    implements ObjectBuilder<ScriptScoreQuery> {
        @Nullable
        private Float minScore;
        private Query query;
        private Script script;

        public final Builder minScore(@Nullable Float value) {
            this.minScore = value;
            return this;
        }

        public final Builder query(Query value) {
            this.query = value;
            return this;
        }

        public final Builder query(Function<Query.Builder, ObjectBuilder<Query>> fn) {
            return this.query(fn.apply(new Query.Builder()).build());
        }

        public final Builder script(Script value) {
            this.script = value;
            return this;
        }

        public final Builder script(Function<Script.Builder, ObjectBuilder<Script>> fn) {
            return this.script(fn.apply(new Script.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public ScriptScoreQuery build() {
            this._checkSingleUse();
            return new ScriptScoreQuery(this);
        }
    }
}

