/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.aggregations;

import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.JsonpSerializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.aggregations.AggregateBase;
import org.opensearch.client.opensearch._types.aggregations.Buckets;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;

public abstract class MultiBucketAggregateBase<TBucket>
extends AggregateBase {
    private final Buckets<TBucket> buckets;
    @Nullable
    private final JsonpSerializer<TBucket> tBucketSerializer;

    protected MultiBucketAggregateBase(AbstractBuilder<TBucket, ?> builder) {
        super(builder);
        this.buckets = ApiTypeHelper.requireNonNull(builder.buckets, this, "buckets");
        this.tBucketSerializer = builder.tBucketSerializer;
    }

    public final Buckets<TBucket> buckets() {
        return this.buckets;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        generator.writeKey("buckets");
        this.buckets.serialize(generator, mapper);
    }

    protected static <TBucket, BuilderT extends AbstractBuilder<TBucket, BuilderT>> void setupMultiBucketAggregateBaseDeserializer(ObjectDeserializer<BuilderT> op, JsonpDeserializer<TBucket> tBucketDeserializer) {
        AggregateBase.setupAggregateBaseDeserializer(op);
        op.add(AbstractBuilder::buckets, Buckets.createBucketsDeserializer(tBucketDeserializer), "buckets");
    }

    protected static abstract class AbstractBuilder<TBucket, BuilderT extends AbstractBuilder<TBucket, BuilderT>>
    extends AggregateBase.AbstractBuilder<BuilderT> {
        private Buckets<TBucket> buckets;
        @Nullable
        private JsonpSerializer<TBucket> tBucketSerializer;

        protected AbstractBuilder() {
        }

        public final BuilderT buckets(Buckets<TBucket> value) {
            this.buckets = value;
            return (BuilderT)((AbstractBuilder)this.self());
        }

        public final BuilderT buckets(Function<Buckets.Builder<TBucket>, ObjectBuilder<Buckets<TBucket>>> fn) {
            return this.buckets(fn.apply(new Buckets.Builder()).build());
        }

        public final BuilderT tBucketSerializer(@Nullable JsonpSerializer<TBucket> value) {
            this.tBucketSerializer = value;
            return (BuilderT)((AbstractBuilder)this.self());
        }
    }
}

