/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.logs.v2.json;

import com.unboundid.ldap.sdk.unboundidds.logs.AccessLogMessageType;
import com.unboundid.ldap.sdk.unboundidds.logs.LogException;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.EntryRebalancingRequestAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.LogField;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.json.JSONAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.json.JSONFormattedAccessLogFields;
import com.unboundid.util.NotExtensible;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.json.JSONObject;

@NotExtensible
@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public class JSONEntryRebalancingRequestAccessLogMessage
extends JSONAccessLogMessage
implements EntryRebalancingRequestAccessLogMessage {
    private static final long serialVersionUID = 144849488576686304L;
    @Nullable
    private final Integer sizeLimit;
    @Nullable
    private final Long rebalancingOperationID = this.getLongNoThrow(JSONFormattedAccessLogFields.ENTRY_REBALANCING_OPERATION_ID);
    @Nullable
    private final Long triggeredByConnectionID = this.getLongNoThrow(JSONFormattedAccessLogFields.TRIGGERED_BY_CONNECTION_ID);
    @Nullable
    private final Long triggeredByOperationID = this.getLongNoThrow(JSONFormattedAccessLogFields.TRIGGERED_BY_OPERATION_ID);
    @Nullable
    private final String sourceBackendServer;
    @Nullable
    private final String sourceBackendSetName;
    @Nullable
    private final String subtreeBaseDN = this.getString(JSONFormattedAccessLogFields.ENTRY_REBALANCING_BASE_DN);
    @Nullable
    private final String targetBackendServer;
    @Nullable
    private final String targetBackendSetName;

    public JSONEntryRebalancingRequestAccessLogMessage(@NotNull JSONObject jsonObject) throws LogException {
        super(jsonObject);
        this.sizeLimit = this.getIntegerNoThrow(JSONFormattedAccessLogFields.ENTRY_REBALANCING_SIZE_LIMIT);
        this.sourceBackendSetName = this.getString(JSONFormattedAccessLogFields.ENTRY_REBALANCING_SOURCE_BACKEND_SET);
        this.sourceBackendServer = JSONEntryRebalancingRequestAccessLogMessage.getBackendServer(jsonObject, JSONFormattedAccessLogFields.ENTRY_REBALANCING_SOURCE_SERVER);
        this.targetBackendSetName = this.getString(JSONFormattedAccessLogFields.ENTRY_REBALANCING_TARGET_BACKEND_SET);
        this.targetBackendServer = JSONEntryRebalancingRequestAccessLogMessage.getBackendServer(jsonObject, JSONFormattedAccessLogFields.ENTRY_REBALANCING_TARGET_SERVER);
    }

    @Nullable
    private static String getBackendServer(@NotNull JSONObject jsonObject, @NotNull LogField logField) {
        JSONObject serverObject = jsonObject.getFieldAsObject(logField.getFieldName());
        if (serverObject == null) {
            return null;
        }
        String address = serverObject.getFieldAsString(JSONFormattedAccessLogFields.ENTRY_REBALANCING_SOURCE_SERVER_ADDRESS.getFieldName());
        if (address == null) {
            return null;
        }
        Integer port = serverObject.getFieldAsInteger(JSONFormattedAccessLogFields.ENTRY_REBALANCING_SOURCE_SERVER_PORT.getFieldName());
        if (port == null) {
            return address;
        }
        return address + ':' + port;
    }

    @Override
    @NotNull
    public AccessLogMessageType getMessageType() {
        return AccessLogMessageType.ENTRY_REBALANCING_REQUEST;
    }

    @Override
    @Nullable
    public final Long getRebalancingOperationID() {
        return this.rebalancingOperationID;
    }

    @Override
    @Nullable
    public final Long getTriggeredByConnectionID() {
        return this.triggeredByConnectionID;
    }

    @Override
    @Nullable
    public final Long getTriggeredByOperationID() {
        return this.triggeredByOperationID;
    }

    @Override
    @Nullable
    public final String getSubtreeBaseDN() {
        return this.subtreeBaseDN;
    }

    @Override
    @Nullable
    public final Integer getSizeLimit() {
        return this.sizeLimit;
    }

    @Override
    @Nullable
    public final String getSourceBackendSetName() {
        return this.sourceBackendSetName;
    }

    @Override
    @Nullable
    public final String getSourceBackendServer() {
        return this.sourceBackendServer;
    }

    @Override
    @Nullable
    public final String getTargetBackendSetName() {
        return this.targetBackendSetName;
    }

    @Override
    @Nullable
    public final String getTargetBackendServer() {
        return this.targetBackendServer;
    }
}

