/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.logs.v2.json;

import com.unboundid.ldap.sdk.unboundidds.logs.LogException;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.AccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.json.JSONFormattedAccessLogFields;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.json.JSONLogMessage;
import com.unboundid.util.NotExtensible;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.json.JSONObject;

@NotExtensible
@ThreadSafety(level=ThreadSafetyLevel.INTERFACE_THREADSAFE)
public abstract class JSONAccessLogMessage
extends JSONLogMessage
implements AccessLogMessage {
    private static final long serialVersionUID = 8694184933366259453L;
    @Nullable
    private final Long connectionID;
    @Nullable
    private final Long threadID;
    @Nullable
    private final String instanceName = this.getString(JSONFormattedAccessLogFields.INSTANCE_NAME);
    @Nullable
    private final String productName = this.getString(JSONFormattedAccessLogFields.PRODUCT_NAME);
    @Nullable
    private final String startupID = this.getString(JSONFormattedAccessLogFields.STARTUP_ID);

    protected JSONAccessLogMessage(@NotNull JSONObject jsonObject) throws LogException {
        super(jsonObject);
        this.threadID = this.getLongNoThrow(JSONFormattedAccessLogFields.THREAD_ID);
        this.connectionID = this.getLongNoThrow(JSONFormattedAccessLogFields.CONNECTION_ID);
    }

    @Override
    @Nullable
    public final String getProductName() {
        return this.productName;
    }

    @Override
    @Nullable
    public final String getInstanceName() {
        return this.instanceName;
    }

    @Override
    @Nullable
    public final String getStartupID() {
        return this.startupID;
    }

    @Override
    @Nullable
    public final Long getThreadID() {
        return this.threadID;
    }

    @Override
    @Nullable
    public final Long getConnectionID() {
        return this.connectionID;
    }
}

