/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.routes;

import com.google.common.base.Preconditions;
import java.util.Optional;
import javax.inject.Inject;
import org.apache.james.core.Username;
import org.apache.james.task.TaskManager;
import org.apache.james.user.api.UsernameChangeTaskStep;
import org.apache.james.user.api.UsersRepository;
import org.apache.james.webadmin.Routes;
import org.apache.james.webadmin.service.UsernameChangeService;
import org.apache.james.webadmin.service.UsernameChangeTask;
import org.apache.james.webadmin.tasks.TaskFromRequestRegistry;
import org.apache.james.webadmin.tasks.TaskRegistrationKey;
import org.apache.james.webadmin.utils.JsonTransformer;
import spark.ResponseTransformer;
import spark.Route;
import spark.Service;

public class UsernameChangeRoutes
implements Routes {
    private static final String OLD_USER_PARAM = "oldUser";
    private static final String NEW_USER_PARAM = "newUser";
    private static final String ROOT_PATH = "/users/:oldUser/rename/:newUser";
    private static final TaskRegistrationKey RENAME = TaskRegistrationKey.of((String)"rename");
    private final UsersRepository usersRepository;
    private final UsernameChangeService service;
    private final TaskManager taskManager;
    private final JsonTransformer jsonTransformer;

    @Inject
    UsernameChangeRoutes(UsersRepository usersRepository, UsernameChangeService service, TaskManager taskManager, JsonTransformer jsonTransformer) {
        this.usersRepository = usersRepository;
        this.service = service;
        this.taskManager = taskManager;
        this.jsonTransformer = jsonTransformer;
    }

    public String getBasePath() {
        return ROOT_PATH;
    }

    public void define(Service service) {
        service.post(ROOT_PATH, this.changeUsername(), (ResponseTransformer)this.jsonTransformer);
    }

    public Route changeUsername() {
        return TaskFromRequestRegistry.of((TaskRegistrationKey)RENAME, request -> {
            Username oldUser = Username.of((String)request.params(OLD_USER_PARAM));
            Username newUser = Username.of((String)request.params(NEW_USER_PARAM));
            Preconditions.checkArgument((boolean)this.usersRepository.contains(oldUser), (Object)"'oldUser' parameter should be an existing user");
            Preconditions.checkArgument((boolean)this.usersRepository.contains(newUser), (Object)"'newUser' parameter should be an existing user");
            Optional<UsernameChangeTaskStep.StepName> fromStep = Optional.ofNullable(request.queryParams("fromStep")).map(UsernameChangeTaskStep.StepName::new);
            return new UsernameChangeTask(this.service, oldUser, newUser, fromStep);
        }).asRoute(this.taskManager);
    }
}

