/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public interface UriMatcher {
    public boolean matches(String var1);

    public Map<String, String> match(String var1);

    public static class Fixed
    implements UriMatcher {
        private static final String QUERY_CHARACTER = "?";
        private final String fixedPath;

        public Fixed(String fixedPath) {
            this.fixedPath = fixedPath;
        }

        @Override
        public boolean matches(String uri) {
            int indexOfQueryCharacter = uri.indexOf(QUERY_CHARACTER);
            if (indexOfQueryCharacter != -1) {
                return uri.substring(0, indexOfQueryCharacter).equals(this.fixedPath);
            }
            return uri.equals(this.fixedPath);
        }

        @Override
        public Map<String, String> match(String uri) {
            return ImmutableMap.of();
        }
    }

    public static class Impl
    implements UriMatcher {
        private static final Pattern FULL_SPLAT_PATTERN = Pattern.compile("[\\*][\\*]");
        private static final String FULL_SPLAT_REPLACEMENT = ".*";
        private static final Pattern NAME_SPLAT_PATTERN = Pattern.compile("\\{([^/]+?)\\}[\\*][\\*]");
        private static final Pattern NAME_PATTERN = Pattern.compile("\\{([^/]+?)\\}");
        private final List<String> pathVariables = new ArrayList<String>();
        private final Pattern uriPattern;

        public static UriMatcher of(String uriPattern) {
            return new Impl(uriPattern);
        }

        private static String getNameSplatReplacement(String name) {
            return "(?<" + name + ">.*)";
        }

        private static String getNameReplacement(String name) {
            return "(?<" + name + ">[^\\/]*)";
        }

        static String filterQueryParams(String uri) {
            int hasQuery = uri.lastIndexOf(63);
            if (hasQuery != -1) {
                return uri.substring(0, hasQuery);
            }
            return uri;
        }

        Impl(String uriPattern) {
            String name;
            int i;
            Object s = "^" + Impl.filterQueryParams(uriPattern);
            Matcher m = NAME_SPLAT_PATTERN.matcher((CharSequence)s);
            while (m.find()) {
                for (i = 1; i <= m.groupCount(); ++i) {
                    name = m.group(i);
                    this.pathVariables.add(name);
                    s = m.replaceFirst(Impl.getNameSplatReplacement(name));
                    m.reset((CharSequence)s);
                }
            }
            m = NAME_PATTERN.matcher((CharSequence)s);
            while (m.find()) {
                for (i = 1; i <= m.groupCount(); ++i) {
                    name = m.group(i);
                    this.pathVariables.add(name);
                    s = m.replaceFirst(Impl.getNameReplacement(name));
                    m.reset((CharSequence)s);
                }
            }
            m = FULL_SPLAT_PATTERN.matcher((CharSequence)s);
            while (m.find()) {
                s = m.replaceAll(FULL_SPLAT_REPLACEMENT);
                m.reset((CharSequence)s);
            }
            this.uriPattern = Pattern.compile((String)s + "$");
        }

        @Override
        public boolean matches(String uri) {
            return this.matcher(uri).matches();
        }

        private Matcher matcher(String uri) {
            uri = Impl.filterQueryParams(uri);
            return this.uriPattern.matcher(uri);
        }

        @Override
        public Map<String, String> match(String uri) {
            HashMap<String, String> pathParameters = new HashMap<String, String>();
            Matcher m = this.matcher(uri);
            if (m.matches()) {
                int i = 1;
                for (String name : this.pathVariables) {
                    String val = m.group(i++);
                    pathParameters.put(name, val);
                }
            }
            return pathParameters;
        }
    }
}

