/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.routes;

import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.james.jmap.Endpoint;
import org.apache.james.jmap.JMAPRoute;
import org.apache.james.jmap.JMAPRoutes;
import org.apache.james.jmap.core.ProblemDetails;
import org.apache.james.jmap.core.ProblemDetails$;
import org.apache.james.jmap.core.RequestObject;
import org.apache.james.jmap.core.ResponseObject;
import org.apache.james.jmap.exceptions.UnauthorizedException;
import org.apache.james.jmap.http.Authenticator;
import org.apache.james.jmap.http.UserProvisioning;
import org.apache.james.jmap.json.ResponseSerializer$;
import org.apache.james.jmap.routes.JMAPApi;
import org.apache.james.jmap.routes.JMAPApiRoutes$;
import org.apache.james.mailbox.MailboxSession;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import play.api.libs.json.JsError;
import play.api.libs.json.JsResult;
import play.api.libs.json.JsSuccess;
import play.api.libs.json.Json$;
import reactor.core.publisher.Mono;
import reactor.core.publisher.SynchronousSink;
import reactor.core.scala.publisher.SMono;
import reactor.core.scala.publisher.SMono$;
import reactor.netty.http.server.HttpServerRequest;
import reactor.netty.http.server.HttpServerResponse;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Tuple2;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.util.Either;

@ScalaSignature(bytes="\u0006\u0005\u0005=v!\u0002\n\u0014\u0011\u0003qb!\u0002\u0011\u0014\u0011\u0003\t\u0003\"\u0002\u0015\u0002\t\u0003I\u0003b\u0002\u0016\u0002\u0005\u0004%\ta\u000b\u0005\u0007e\u0005\u0001\u000b\u0011\u0002\u0017\u0007\t\u0001\u001a\u0002a\r\u0005\t\u0001\u0016\u0011)\u0019!C\u0001\u0003\"A\u0001*\u0002B\u0001B\u0003%!\t\u0003\u0005J\u000b\t\u0005\t\u0015!\u0003K\u0011!iUA!A!\u0002\u0013q\u0005\"\u0002\u0015\u0006\t\u0003\t\u0006\"\u0002\u000b\u0006\t\u00032\u0007\"\u0002:\u0006\t\u0013\u0019\bbBA\u0012\u000b\u0011%\u0011Q\u0005\u0005\b\u0003\u007f)A\u0011BA!\u0011\u001d\t\t(\u0002C\u0005\u0003gBq!!$\u0006\t\u0013\ty\tC\u0004\u0002 \u0016!I!!)\u0002\u001b)k\u0015\tU!qSJ{W\u000f^3t\u0015\t!R#\u0001\u0004s_V$Xm\u001d\u0006\u0003-]\tAA[7ba*\u0011\u0001$G\u0001\u0006U\u0006lWm\u001d\u0006\u00035m\ta!\u00199bG\",'\"\u0001\u000f\u0002\u0007=\u0014xm\u0001\u0001\u0011\u0005}\tQ\"A\n\u0003\u001b)k\u0015\tU!qSJ{W\u000f^3t'\t\t!\u0005\u0005\u0002$M5\tAEC\u0001&\u0003\u0015\u00198-\u00197b\u0013\t9CE\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003y\ta\u0001T(H\u000f\u0016\u0013V#\u0001\u0017\u0011\u00055\u0002T\"\u0001\u0018\u000b\u0005=Z\u0012!B:mMRR\u0017BA\u0019/\u0005\u0019aunZ4fe\u00069AjT$H\u000bJ\u00033cA\u00035yA\u0011QGO\u0007\u0002m)\u0011q\u0007O\u0001\u0005Y\u0006twMC\u0001:\u0003\u0011Q\u0017M^1\n\u0005m2$AB(cU\u0016\u001cG\u000f\u0005\u0002>}5\tQ#\u0003\u0002@+\tQ!*T!Q%>,H/Z:\u0002\u001b\u0005,H\u000f[3oi&\u001c\u0017\r^8s+\u0005\u0011\u0005CA\"G\u001b\u0005!%BA#\u0016\u0003\u0011AG\u000f\u001e9\n\u0005\u001d#%!D!vi\",g\u000e^5dCR|'/\u0001\bbkRDWM\u001c;jG\u0006$xN\u001d\u0011\u0002\u001fU\u001cXM\u001d)s_ZL7/[8oKJ\u0004\"aQ&\n\u00051#%\u0001E+tKJ\u0004&o\u001c<jg&|g.\u001b8h\u0003\u001dQW.\u00199Ba&\u0004\"aH(\n\u0005A\u001b\"a\u0002&N\u0003B\u000b\u0005/\u001b\u000b\u0005%N\u0003\u0017\r\u0005\u0002 \u000b!)\u0001I\u0003a\u0001\u0005\"\"1+V/_!\t16,D\u0001X\u0015\tA\u0016,\u0001\u0004j]*,7\r\u001e\u0006\u00025\u0006)!.\u0019<bq&\u0011Al\u0016\u0002\u0006\u001d\u0006lW\rZ\u0001\u0006m\u0006dW/Z\u0011\u0002?\u0006A!KR\".qY\u0012\u0014\u0007C\u0003J\u0015\u0001\u0007!\nC\u0003N\u0015\u0001\u0007a\n\u000b\u0002\u000bGB\u0011a\u000bZ\u0005\u0003K^\u0013a!\u00138kK\u000e$H#A4\u0011\u0007!lw.D\u0001j\u0015\tQ7.\u0001\u0004tiJ,\u0017-\u001c\u0006\u0003Yb\nA!\u001e;jY&\u0011a.\u001b\u0002\u0007'R\u0014X-Y7\u0011\u0005u\u0002\u0018BA9\u0016\u0005%QU*\u0011)S_V$X-\u0001\u0003q_N$H#\u0002;\u0002\u0004\u0005e\u0001cA;}}6\taO\u0003\u0002xq\u0006I\u0001/\u001e2mSNDWM\u001d\u0006\u0003sj\fAaY8sK*\t10A\u0004sK\u0006\u001cGo\u001c:\n\u0005u4(\u0001B'p]>\u0004\"!N@\n\u0007\u0005\u0005aG\u0001\u0003W_&$\u0007bBA\u0003\u0019\u0001\u0007\u0011qA\u0001\u0012QR$\boU3sm\u0016\u0014(+Z9vKN$\b\u0003BA\u0005\u0003+i!!a\u0003\u000b\t\u00055\u0011qB\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0007\u0015\u000b\tBC\u0002\u0002\u0014i\fQA\\3uifLA!a\u0006\u0002\f\t\t\u0002\n\u001e;q'\u0016\u0014h/\u001a:SKF,Xm\u001d;\t\u000f\u0005mA\u00021\u0001\u0002\u001e\u0005\u0011\u0002\u000e\u001e;q'\u0016\u0014h/\u001a:SKN\u0004xN\\:f!\u0011\tI!a\b\n\t\u0005\u0005\u00121\u0002\u0002\u0013\u0011R$\boU3sm\u0016\u0014(+Z:q_:\u001cX-A\nsKF,Xm\u001d;Bg*\u001bxN\\*ue\u0016\fW\u000e\u0006\u0003\u0002(\u0005u\u0002CBA\u0015\u0003_\t\u0019$\u0004\u0002\u0002,)\u0019q/!\f\u000b\u0005\u0015B\u0018\u0002BA\u0019\u0003W\u0011QaU'p]>\u0004B!!\u000e\u0002:5\u0011\u0011q\u0007\u0006\u0003sVIA!a\u000f\u00028\ti!+Z9vKN$xJ\u00196fGRDq!!\u0002\u000e\u0001\u0004\t9!\u0001\nqCJ\u001cXMU3rk\u0016\u001cHo\u00142kK\u000e$H\u0003BA\"\u0003C\u0002\u0002\"!\u0012\u0002V\u0005m\u00131\u0007\b\u0005\u0003\u000f\n\tF\u0004\u0003\u0002J\u0005=SBAA&\u0015\r\ti%H\u0001\u0007yI|w\u000e\u001e \n\u0003\u0015J1!a\u0015%\u0003\u001d\u0001\u0018mY6bO\u0016LA!a\u0016\u0002Z\t1Q)\u001b;iKJT1!a\u0015%!\u0011\t)%!\u0018\n\t\u0005}\u0013\u0011\f\u0002\u0019\u00132dWmZ1m\u0003J<W/\\3oi\u0016C8-\u001a9uS>t\u0007bBA2\u001d\u0001\u0007\u0011QM\u0001\fS:\u0004X\u000f^*ue\u0016\fW\u000e\u0005\u0003\u0002h\u00055TBAA5\u0015\r\tY\u0007O\u0001\u0003S>LA!a\u001c\u0002j\tY\u0011J\u001c9viN#(/Z1n\u0003\u001d\u0001(o\\2fgN$\u0002\"!\u001e\u0002x\u0005m\u0014Q\u0010\t\u0006\u0003S\tyC \u0005\b\u0003sz\u0001\u0019AA\u001a\u00035\u0011X-];fgR|%M[3di\"9\u00111D\bA\u0002\u0005u\u0001bBA@\u001f\u0001\u0007\u0011\u0011Q\u0001\u000f[\u0006LGNY8y'\u0016\u001c8/[8o!\u0011\t\u0019)!#\u000e\u0005\u0005\u0015%bAAD/\u00059Q.Y5mE>D\u0018\u0002BAF\u0003\u000b\u0013a\"T1jY\n|\u0007pU3tg&|g.A\u0006iC:$G.Z#se>\u0014HCBA;\u0003#\u000bY\nC\u0004\u0002\u0014B\u0001\r!!&\u0002\u0013QD'o\\<bE2,\u0007\u0003BA#\u0003/KA!!'\u0002Z\tIA\u000b\u001b:po\u0006\u0014G.\u001a\u0005\b\u0003;\u0003\u0002\u0019AA\u000f\u0003!\u0011Xm\u001d9p]N,\u0017A\u0004:fgB|g\u000e\u001a#fi\u0006LGn\u001d\u000b\u0007\u0003k\n\u0019+!*\t\u000f\u0005m\u0011\u00031\u0001\u0002\u001e!9\u0011qU\tA\u0002\u0005%\u0016a\u00023fi\u0006LGn\u001d\t\u0005\u0003k\tY+\u0003\u0003\u0002.\u0006]\"A\u0004)s_\ndW-\u001c#fi\u0006LGn\u001d")
public class JMAPApiRoutes
implements JMAPRoutes {
    private final Authenticator authenticator;
    private final UserProvisioning userProvisioner;
    private final JMAPApi jmapApi;

    public static Logger LOGGER() {
        return JMAPApiRoutes$.MODULE$.LOGGER();
    }

    public Mono<Void> handleInternalError(HttpServerResponse x$1, Logger x$2, Throwable x$3) {
        return super.handleInternalError(x$1, x$2, x$3);
    }

    public Mono<Void> handleBadRequest(HttpServerResponse x$1, Logger x$2, Throwable x$3) {
        return super.handleBadRequest(x$1, x$2, x$3);
    }

    public Mono<Void> handleAuthenticationFailure(HttpServerResponse x$1, Logger x$2, Throwable x$3) {
        return super.handleAuthenticationFailure(x$1, x$2, x$3);
    }

    public Authenticator authenticator() {
        return this.authenticator;
    }

    public Stream<JMAPRoute> routes() {
        return Stream.of((Object[])new JMAPRoute[]{JMAPRoute.builder().endpoint(Endpoint.ofFixedPath((HttpMethod)HttpMethod.POST, (String)"/jmap")).action((httpServerRequest, httpServerResponse) -> this.post(httpServerRequest, httpServerResponse)).corsHeaders(), JMAPRoute.builder().endpoint(Endpoint.ofFixedPath((HttpMethod)HttpMethod.OPTIONS, (String)"/jmap")).action(JMAPRoutes.CORS_CONTROL).corsHeaders()});
    }

    private Mono<Void> post(HttpServerRequest httpServerRequest, HttpServerResponse httpServerResponse) {
        return SMono$.MODULE$.apply((Publisher)this.authenticator().authenticate(httpServerRequest)).flatMap((Function1 & Serializable)mailboxSession -> $this.userProvisioner.provisionUser((MailboxSession)mailboxSession).then().then(this.requestAsJsonStream(httpServerRequest).flatMap((Function1 & Serializable)requestObject -> this.process((RequestObject)requestObject, httpServerResponse, (MailboxSession)mailboxSession)))).onErrorResume((Function1 & Serializable)throwable -> this.handleError((Throwable)throwable, httpServerResponse)).asJava().then();
    }

    private SMono<RequestObject> requestAsJsonStream(HttpServerRequest httpServerRequest) {
        return SMono$.MODULE$.fromPublisher((Publisher)httpServerRequest.receive().aggregate().asInputStream()).handle((Function2 & Serializable)(x0$1, x1$1) -> {
            JMAPApiRoutes.$anonfun$requestAsJsonStream$1(this, x0$1, x1$1);
            return BoxedUnit.UNIT;
        });
    }

    private Either<IllegalArgumentException, RequestObject> parseRequestObject(InputStream inputStream) {
        JsResult<RequestObject> jsResult = ResponseSerializer$.MODULE$.deserializeRequestObject(inputStream);
        if (jsResult instanceof JsSuccess) {
            JsSuccess jsSuccess = (JsSuccess)jsResult;
            RequestObject requestObject = (RequestObject)jsSuccess.value();
            return package$.MODULE$.Right().apply((Object)requestObject);
        }
        if (jsResult instanceof JsError) {
            JsError jsError = (JsError)jsResult;
            return package$.MODULE$.Left().apply((Object)new IllegalArgumentException(ResponseSerializer$.MODULE$.serialize(jsError).toString()));
        }
        throw new MatchError(jsResult);
    }

    private SMono<Void> process(RequestObject requestObject, HttpServerResponse httpServerResponse, MailboxSession mailboxSession) {
        return this.jmapApi.process(requestObject, mailboxSession).map((Function1 & Serializable)responseObject -> ResponseSerializer$.MODULE$.serialize((ResponseObject)responseObject)).map((Function1 & Serializable)json -> Json$.MODULE$.stringify(json)).map((Function1 & Serializable)x$1 -> x$1.getBytes(StandardCharsets.UTF_8)).flatMap((Function1 & Serializable)bytes -> SMono$.MODULE$.fromPublisher((Publisher)httpServerResponse.status(HttpResponseStatus.OK).header((CharSequence)HttpHeaderNames.CONTENT_TYPE, (CharSequence)"application/json").header((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (CharSequence)Integer.toString(((byte[])bytes).length)).sendByteArray((Publisher)SMono$.MODULE$.just(bytes)).then()));
    }

    private SMono<Void> handleError(Throwable throwable, HttpServerResponse response) {
        Throwable throwable2 = throwable;
        if (throwable2 instanceof UnauthorizedException) {
            UnauthorizedException unauthorizedException = (UnauthorizedException)throwable2;
            return this.respondDetails(unauthorizedException.addHeaders(response), ProblemDetails$.MODULE$.forThrowable(throwable));
        }
        return this.respondDetails(response, ProblemDetails$.MODULE$.forThrowable(throwable));
    }

    private SMono<Void> respondDetails(HttpServerResponse httpServerResponse, ProblemDetails details) {
        return SMono$.MODULE$.fromCallable(() -> ResponseSerializer$.MODULE$.serialize(details).toString()).map((Function1 & Serializable)x$2 -> x$2.getBytes(StandardCharsets.UTF_8)).flatMap((Function1 & Serializable)bytes -> SMono$.MODULE$.fromPublisher((Publisher)httpServerResponse.status(details.status()).header((CharSequence)HttpHeaderNames.CONTENT_TYPE, (CharSequence)"application/json").header((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (CharSequence)Integer.toString(((byte[])bytes).length)).sendByteArray((Publisher)SMono$.MODULE$.just(bytes)).then()));
    }

    public static final /* synthetic */ void $anonfun$requestAsJsonStream$1(JMAPApiRoutes $this, InputStream x0$1, SynchronousSink x1$1) {
        Tuple2 tuple2 = new Tuple2((Object)x0$1, (Object)x1$1);
        if (tuple2 != null) {
            InputStream input = (InputStream)tuple2._1();
            SynchronousSink sink = (SynchronousSink)tuple2._2();
            BoxedUnit cfr_ignored_0 = (BoxedUnit)$this.parseRequestObject(input).fold((Function1 & Serializable)x$1 -> {
                sink.error(x$1);
                return BoxedUnit.UNIT;
            }, (Function1 & Serializable)x$1 -> {
                sink.next((Object)x$1);
                return BoxedUnit.UNIT;
            });
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    @Inject
    public JMAPApiRoutes(@Named(value="RFC-8621") Authenticator authenticator, UserProvisioning userProvisioner, JMAPApi jmapApi) {
        this.authenticator = authenticator;
        this.userProvisioner = userProvisioner;
        this.jmapApi = jmapApi;
    }
}

