/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.backends.opensearch;

import java.io.IOException;
import org.apache.james.backends.opensearch.ReactorOpenSearchClient;
import org.apache.james.backends.opensearch.RoutingKey;
import org.apache.james.backends.opensearch.WriteAliasName;
import org.opensearch.client.opensearch._types.query_dsl.Query;
import org.opensearch.client.opensearch.core.DeleteByQueryRequest;
import reactor.core.publisher.Mono;

public class DeleteByQueryPerformer {
    private final ReactorOpenSearchClient client;
    private final WriteAliasName aliasName;

    DeleteByQueryPerformer(ReactorOpenSearchClient client, WriteAliasName aliasName) {
        this.client = client;
        this.aliasName = aliasName;
    }

    public Mono<Void> perform(Query query, RoutingKey routingKey) {
        DeleteByQueryRequest deleteRequest = new DeleteByQueryRequest.Builder().index(this.aliasName.getValue(), new String[0]).query(query).routing(routingKey.asString()).build();
        try {
            return this.client.deleteByQuery(deleteRequest).then();
        }
        catch (IOException e) {
            return Mono.error((Throwable)e);
        }
    }

    public Mono<Void> perform(Query query) {
        DeleteByQueryRequest deleteRequest = new DeleteByQueryRequest.Builder().index(this.aliasName.getValue(), new String[0]).query(query).build();
        try {
            return this.client.deleteByQuery(deleteRequest).then();
        }
        catch (IOException e) {
            return Mono.error((Throwable)e);
        }
    }
}

