/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.qp.physical.crud;

import java.time.ZoneId;
import java.util.HashSet;
import java.util.Map;
import org.apache.iotdb.db.exception.metadata.MetadataException;
import org.apache.iotdb.db.qp.logical.Operator;
import org.apache.iotdb.db.qp.physical.crud.AggregationPlan;
import org.apache.iotdb.db.qp.physical.crud.UDTFPlan;
import org.apache.iotdb.db.qp.strategy.PhysicalGenerator;
import org.apache.iotdb.db.query.expression.Expression;
import org.apache.iotdb.db.query.expression.ResultColumn;
import org.apache.iotdb.service.rpc.thrift.TSExecuteStatementResp;
import org.apache.thrift.TException;

public class UDAFPlan
extends UDTFPlan {
    private AggregationPlan innerAggregationPlan;

    public UDAFPlan(ZoneId zoneId) {
        super(zoneId);
        this.setOperatorType(Operator.OperatorType.UDAF);
    }

    @Override
    public TSExecuteStatementResp getTSExecuteStatementResp(boolean isJdbcQuery) throws TException, MetadataException {
        TSExecuteStatementResp resp = super.getTSExecuteStatementResp(isJdbcQuery);
        if (this.getInnerAggregationPlan().getOperatorType() == Operator.OperatorType.AGGREGATION) {
            resp.setIgnoreTimeStamp(true);
        }
        return resp;
    }

    public void setExpressionToInnerResultIndexMap(Map<Expression, Integer> expressionToInnerResultIndexMap) {
        expressionToInnerResultIndexMap.forEach((k, v) -> this.pathNameToReaderIndex.put(k.toString(), v));
    }

    public void setInnerAggregationPlan(AggregationPlan innerAggregationPlan) {
        this.innerAggregationPlan = innerAggregationPlan;
    }

    public AggregationPlan getInnerAggregationPlan() {
        return this.innerAggregationPlan;
    }

    @Override
    public void deduplicate(PhysicalGenerator physicalGenerator) throws MetadataException {
        HashSet<String> columnForDisplaySet = new HashSet<String>();
        for (int i = 0; i < this.resultColumns.size(); ++i) {
            String columnForDisplay = ((ResultColumn)this.resultColumns.get(i)).getResultColumnName();
            if (columnForDisplaySet.contains(columnForDisplay)) continue;
            int datasetOutputIndex = this.getPathToIndex().size();
            this.setColumnNameToDatasetOutputIndex(columnForDisplay, datasetOutputIndex);
            this.setDatasetOutputIndexToResultColumnIndex(datasetOutputIndex, i);
            columnForDisplaySet.add(columnForDisplay);
        }
    }
}

