/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomi.youpin.docean.mvc.download;

import com.google.common.base.Stopwatch;
import io.netty.channel.ChannelProgressiveFuture;
import io.netty.channel.ChannelProgressiveFutureListener;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DownloadListener
implements ChannelProgressiveFutureListener {
    private static final Logger log = LoggerFactory.getLogger(DownloadListener.class);
    private Stopwatch stopwatch = Stopwatch.createStarted();
    private int num = 0;
    private String id;
    private long fileLength;

    public DownloadListener(String id, long fileLength) {
        this.id = id;
        this.fileLength = fileLength;
    }

    public void operationProgressed(ChannelProgressiveFuture future, long progress, long total) {
        int value = (int)((float)progress * 1.0f / (float)total * 100.0f);
        if (value - this.num >= 25) {
            this.num = value;
            log.info("download:{} {}/100", (Object)this.id, (Object)this.num);
        }
    }

    public void operationComplete(ChannelProgressiveFuture future) {
        long time = this.stopwatch.elapsed(TimeUnit.SECONDS);
        if (time <= 0L) {
            time = 1L;
        }
        try {
            if (this.fileLength > 0L && this.fileLength / time > 0L) {
                try {
                    long speed = this.fileLength / time / 1024L;
                    log.info("download:{} finish use time:{} speed:{}kb  size:{}", new Object[]{this.id, time, speed, this.fileLength / 1024L + "kb"});
                }
                catch (Throwable throwable) {}
            } else {
                log.info("download:{} finish size:{}", (Object)this.id, (Object)(this.fileLength / 1024L + "kb"));
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

