/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.trace.etl.es.queue.impl;

import com.alibaba.fastjson.JSONObject;
import com.xiaomi.data.push.common.SnowFlake;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.apache.ozhera.trace.etl.es.util.redis.RedisClientUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class TeSnowFlake
extends SnowFlake
implements InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(TeSnowFlake.class);
    private static final long BATCH_CNT = 77L;
    private static final String SN_KEY_PREFIX = "te_sn";
    private static final String SN_KEY_STMP = "te_sn_last_timestamp";
    public static final String FIRST_TIMESTAMP_REDIS_PREFIX = "first_new";
    public static final String SECOND_TIMESTAMP_REDIS_PREFIX = "second_new";
    private static AtomicLong STORE_CNT = new AtomicLong(0L);
    private static AtomicLong SAVED_LAST_STMP = new AtomicLong(-1L);
    public static String SN_KEY_WORK_ID;
    private String mId;
    @Autowired
    private RedisClientUtil redis;
    @Value(value="${gw.snowflake.datacenterId:0}")
    private long datacenterId;

    @PostConstruct
    public void init() {
        ((SnowFlake)this).datacenterId = this.makeDatacenterId1(this.maxDatacenterId);
        this.workerId = this.makeWorkerId1(this.datacenterId, this.maxWorkerId);
        this.afterPropertiesSet();
        String podName = System.getenv("MONE_CONTAINER_S_POD_NAME");
        if (StringUtils.isEmpty((CharSequence)podName)) {
            log.error("this pod can't get podName!");
            throw new RuntimeException("this pod can't get podName!");
        }
        this.mId = podName.substring(podName.lastIndexOf("-") + 1);
    }

    private long makeDatacenterId1(long maxDatacenterId) {
        long did = this.datacenterId % (maxDatacenterId + 1L);
        log.warn("GwSnowFlake, datacenterId:{}, origin_datacenterId:{}, maxDatacenterId:{}", new Object[]{did, this.datacenterId, maxDatacenterId});
        return did;
    }

    private long makeWorkerId1(long datacenterId, long maxWorkerId) {
        int i = 0;
        while ((long)i < maxWorkerId) {
            long workId = super.makeWorkerId(datacenterId, maxWorkerId);
            SN_KEY_WORK_ID = "te_sn_workId" + workId;
            Long setNx = this.redis.setNx((String)SN_KEY_WORK_ID, "1");
            if (1L == setNx) {
                log.warn("GwSnowFlake workId:{}", (Object)workId);
                return workId;
            }
            ++i;
        }
        long lastWorkId = super.makeWorkerId(datacenterId, maxWorkerId);
        log.error("GwSnowFlake have no workId available, maxWorkerId:{}, lastWorkId:{}", (Object)maxWorkerId, (Object)lastWorkId);
        return lastWorkId;
    }

    public String recoverLastTimestamp(String keyPrefix) {
        try {
            String value = this.redis.get(keyPrefix + "_te_sn_last_timestamp_" + this.mId);
            if (StringUtils.isEmpty((CharSequence)keyPrefix)) {
                return null;
            }
            return value;
        }
        catch (Exception e) {
            log.error("recoverLastTimestamp exception:{}", (Throwable)e);
            return null;
        }
    }

    public void storeLastTimestamp(String keyPrefix, String lastRocksKey) {
        long cnt = STORE_CNT.addAndGet(1L);
        long lastTimestamp = Long.parseLong(lastRocksKey.split("_")[0]);
        boolean needSave = false;
        if (cnt % 77L == 0L) {
            needSave = true;
        } else if (lastTimestamp - SAVED_LAST_STMP.get() > 5000L) {
            needSave = true;
        }
        if (needSave) {
            this.redis.set(keyPrefix + "_te_sn_last_timestamp_" + this.mId, lastRocksKey);
            SAVED_LAST_STMP.set(lastTimestamp);
        }
    }

    public void afterPropertiesSet() {
    }

    public static void main(String[] args) {
        JSONObject json = new JSONObject();
        json.put("refer", new ArrayList());
        System.out.println(json.toJSONString());
    }
}

