/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.spring.context.event.config;

import com.alibaba.nacos.api.config.listener.AbstractListener;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TimeoutNacosConfigListener
extends AbstractListener {
    static AtomicInteger id = new AtomicInteger(0);
    static ExecutorService executorService = Executors.newScheduledThreadPool(8, new ThreadFactory(){

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(r);
            t.setDaemon(true);
            t.setName("com.alibaba.nacos.spring.configListener-" + id.incrementAndGet());
            return t;
        }
    });
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final String dataId;
    private final String groupId;
    private final long timeout;

    public TimeoutNacosConfigListener(String dataId, String groupId, long timeout) {
        this.dataId = dataId;
        this.groupId = groupId;
        this.timeout = timeout;
    }

    public void receiveConfigInfo(final String content) {
        block4: {
            Future<?> future = executorService.submit(new Runnable(){

                @Override
                public void run() {
                    TimeoutNacosConfigListener.this.onReceived(content);
                }
            });
            try {
                future.get(this.timeout, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException(e);
            }
            catch (ExecutionException e) {
                throw new RuntimeException(e);
            }
            catch (TimeoutException e) {
                future.cancel(true);
                if (!this.logger.isWarnEnabled()) break block4;
                this.logger.warn("Listening on Nacos Config exceeds timeout {} ms [dataId : {}, groupId : {}, data : {}]", new Object[]{this.timeout, this.dataId, this.groupId, content});
            }
        }
    }

    protected abstract void onReceived(String var1);

    public long getTimeout() {
        return this.timeout;
    }
}

