/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomi.youpin.docean.plugin.db;

import com.xiaomi.youpin.docean.Aop;
import com.xiaomi.youpin.docean.Ioc;
import com.xiaomi.youpin.docean.anno.DOceanPlugin;
import com.xiaomi.youpin.docean.plugin.IPlugin;
import com.xiaomi.youpin.docean.plugin.config.Config;
import com.xiaomi.youpin.docean.plugin.datasource.DatasourceConfig;
import com.xiaomi.youpin.docean.plugin.db.Transactional;
import com.xiaomi.youpin.docean.plugin.db.interceptor.DaoTimeInterceptor;
import com.xiaomi.youpin.docean.plugin.db.interceptor.DoceanInterceptor;
import com.xiaomi.youpin.docean.plugin.db.interceptor.NutzDaoMeshInvoker;
import com.xiaomi.youpin.docean.plugin.db.interceptor.TransactionalInterceptor;
import java.util.List;
import java.util.Set;
import javax.sql.DataSource;
import org.nutz.dao.impl.NutDao;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DOceanPlugin
public class DbPlugin
implements IPlugin {
    private static final Logger log = LoggerFactory.getLogger(DbPlugin.class);
    public static final String INTERCEPTOR_NAME = "nutzDaoInterceptor";
    public static final String DB_OPEN_TRANSACTIONAL_FLAG = "db_open_transactional";
    public static final String PRINT_SQL_FLAG = "db_print_sql";

    public void init(Set<? extends Class<?>> classSet, Ioc ioc) {
        log.info("init db plugin");
        Config config = (Config)ioc.getBean(Config.class);
        if (config.get(DB_OPEN_TRANSACTIONAL_FLAG, Boolean.FALSE.toString()).equals("true")) {
            Aop.ins().getInterceptorMap().put(Transactional.class, new TransactionalInterceptor());
        }
        String printSql = config.get(PRINT_SQL_FLAG, Boolean.TRUE.toString());
        List dbNames = (List)ioc.getBean("DB_NAMES");
        if (dbNames.size() == 1) {
            NutDao nutDao = new NutDao((DataSource)ioc.getBean((String)dbNames.get(0)));
            nutDao.addInterceptor((Object)new DaoTimeInterceptor(printSql));
            if (ioc.containsBean(INTERCEPTOR_NAME)) {
                NutzDaoMeshInvoker invoker = (NutzDaoMeshInvoker)ioc.getBean(INTERCEPTOR_NAME);
                DoceanInterceptor interceptor = new DoceanInterceptor();
                interceptor.setMeshInvoker(invoker);
                nutDao.addInterceptor((Object)interceptor);
            }
            ioc.putBean((Object)nutDao);
        } else {
            dbNames.stream().forEach(it -> this.addDAO(ioc, (String)it, printSql));
        }
    }

    private void addDAO(Ioc ioc, String beanName, String printSql) {
        Object dataSource = ioc.getBean(beanName);
        if (dataSource instanceof DataSource) {
            NutDao dao = new NutDao((DataSource)dataSource);
            dao.addInterceptor((Object)new DaoTimeInterceptor(printSql));
            if (ioc.containsBean(INTERCEPTOR_NAME)) {
                NutzDaoMeshInvoker invoker = (NutzDaoMeshInvoker)ioc.getBean(INTERCEPTOR_NAME);
                DoceanInterceptor interceptor = new DoceanInterceptor();
                DatasourceConfig config = (DatasourceConfig)ioc.getBean(beanName + "_config");
                interceptor.setMeshInvoker(invoker);
                interceptor.setDatasourceConfig(config);
                dao.addInterceptor((Object)interceptor);
            }
            ioc.putBean("nutz_" + beanName, (Object)dao);
        }
    }

    public String version() {
        return "0.0.1:goodjava@qq.com:20210829";
    }
}

